package dms_enterprise

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetTaskInstanceRelation invokes the dms_enterprise.GetTaskInstanceRelation API synchronously
func (client *Client) GetTaskInstanceRelation(request *GetTaskInstanceRelationRequest) (response *GetTaskInstanceRelationResponse, err error) {
	response = CreateGetTaskInstanceRelationResponse()
	err = client.DoAction(request, response)
	return
}

// GetTaskInstanceRelationWithChan invokes the dms_enterprise.GetTaskInstanceRelation API asynchronously
func (client *Client) GetTaskInstanceRelationWithChan(request *GetTaskInstanceRelationRequest) (<-chan *GetTaskInstanceRelationResponse, <-chan error) {
	responseChan := make(chan *GetTaskInstanceRelationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetTaskInstanceRelation(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetTaskInstanceRelationWithCallback invokes the dms_enterprise.GetTaskInstanceRelation API asynchronously
func (client *Client) GetTaskInstanceRelationWithCallback(request *GetTaskInstanceRelationRequest, callback func(response *GetTaskInstanceRelationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetTaskInstanceRelationResponse
		var err error
		defer close(result)
		response, err = client.GetTaskInstanceRelation(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetTaskInstanceRelationRequest is the request struct for api GetTaskInstanceRelation
type GetTaskInstanceRelationRequest struct {
	*requests.RpcRequest
	DagId         requests.Integer `position:"Query" name:"DagId"`
	Tid           requests.Integer `position:"Query" name:"Tid"`
	DagInstanceId requests.Integer `position:"Query" name:"DagInstanceId"`
}

// GetTaskInstanceRelationResponse is the response struct for api GetTaskInstanceRelation
type GetTaskInstanceRelationResponse struct {
	*responses.BaseResponse
	RequestId    string   `json:"RequestId" xml:"RequestId"`
	ErrorCode    string   `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage string   `json:"ErrorMessage" xml:"ErrorMessage"`
	Success      bool     `json:"Success" xml:"Success"`
	NodeList     NodeList `json:"NodeList" xml:"NodeList"`
}

// CreateGetTaskInstanceRelationRequest creates a request to invoke GetTaskInstanceRelation API
func CreateGetTaskInstanceRelationRequest() (request *GetTaskInstanceRelationRequest) {
	request = &GetTaskInstanceRelationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dms-enterprise", "2018-11-01", "GetTaskInstanceRelation", "dms-enterprise", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetTaskInstanceRelationResponse creates a response to parse from GetTaskInstanceRelation response
func CreateGetTaskInstanceRelationResponse() (response *GetTaskInstanceRelationResponse) {
	response = &GetTaskInstanceRelationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
