package dms_enterprise

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// MoveTaskFlowToScenario invokes the dms_enterprise.MoveTaskFlowToScenario API synchronously
func (client *Client) MoveTaskFlowToScenario(request *MoveTaskFlowToScenarioRequest) (response *MoveTaskFlowToScenarioResponse, err error) {
	response = CreateMoveTaskFlowToScenarioResponse()
	err = client.DoAction(request, response)
	return
}

// MoveTaskFlowToScenarioWithChan invokes the dms_enterprise.MoveTaskFlowToScenario API asynchronously
func (client *Client) MoveTaskFlowToScenarioWithChan(request *MoveTaskFlowToScenarioRequest) (<-chan *MoveTaskFlowToScenarioResponse, <-chan error) {
	responseChan := make(chan *MoveTaskFlowToScenarioResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.MoveTaskFlowToScenario(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// MoveTaskFlowToScenarioWithCallback invokes the dms_enterprise.MoveTaskFlowToScenario API asynchronously
func (client *Client) MoveTaskFlowToScenarioWithCallback(request *MoveTaskFlowToScenarioRequest, callback func(response *MoveTaskFlowToScenarioResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *MoveTaskFlowToScenarioResponse
		var err error
		defer close(result)
		response, err = client.MoveTaskFlowToScenario(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// MoveTaskFlowToScenarioRequest is the request struct for api MoveTaskFlowToScenario
type MoveTaskFlowToScenarioRequest struct {
	*requests.RpcRequest
	DagId      requests.Integer `position:"Query" name:"DagId"`
	Tid        requests.Integer `position:"Query" name:"Tid"`
	ScenarioId requests.Integer `position:"Query" name:"ScenarioId"`
}

// MoveTaskFlowToScenarioResponse is the response struct for api MoveTaskFlowToScenario
type MoveTaskFlowToScenarioResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	ErrorCode    string `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Success      bool   `json:"Success" xml:"Success"`
}

// CreateMoveTaskFlowToScenarioRequest creates a request to invoke MoveTaskFlowToScenario API
func CreateMoveTaskFlowToScenarioRequest() (request *MoveTaskFlowToScenarioRequest) {
	request = &MoveTaskFlowToScenarioRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dms-enterprise", "2018-11-01", "MoveTaskFlowToScenario", "dms-enterprise", "openAPI")
	request.Method = requests.POST
	return
}

// CreateMoveTaskFlowToScenarioResponse creates a response to parse from MoveTaskFlowToScenario response
func CreateMoveTaskFlowToScenarioResponse() (response *MoveTaskFlowToScenarioResponse) {
	response = &MoveTaskFlowToScenarioResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
