package dt_oc_info

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetOcJusticeExecuted invokes the dt_oc_info.GetOcJusticeExecuted API synchronously
func (client *Client) GetOcJusticeExecuted(request *GetOcJusticeExecutedRequest) (response *GetOcJusticeExecutedResponse, err error) {
	response = CreateGetOcJusticeExecutedResponse()
	err = client.DoAction(request, response)
	return
}

// GetOcJusticeExecutedWithChan invokes the dt_oc_info.GetOcJusticeExecuted API asynchronously
func (client *Client) GetOcJusticeExecutedWithChan(request *GetOcJusticeExecutedRequest) (<-chan *GetOcJusticeExecutedResponse, <-chan error) {
	responseChan := make(chan *GetOcJusticeExecutedResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetOcJusticeExecuted(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetOcJusticeExecutedWithCallback invokes the dt_oc_info.GetOcJusticeExecuted API asynchronously
func (client *Client) GetOcJusticeExecutedWithCallback(request *GetOcJusticeExecutedRequest, callback func(response *GetOcJusticeExecutedResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetOcJusticeExecutedResponse
		var err error
		defer close(result)
		response, err = client.GetOcJusticeExecuted(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetOcJusticeExecutedRequest is the request struct for api GetOcJusticeExecuted
type GetOcJusticeExecutedRequest struct {
	*requests.RpcRequest
	RequestId string           `position:"Body" name:"RequestId"`
	PageNo    requests.Integer `position:"Body" name:"PageNo"`
	PageSize  requests.Integer `position:"Body" name:"PageSize"`
	SearchKey string           `position:"Body" name:"SearchKey"`
}

// GetOcJusticeExecutedResponse is the response struct for api GetOcJusticeExecuted
type GetOcJusticeExecutedResponse struct {
	*responses.BaseResponse
	Code      string     `json:"Code" xml:"Code"`
	Success   bool       `json:"Success" xml:"Success"`
	Message   string     `json:"Message" xml:"Message"`
	TotalNum  int        `json:"TotalNum" xml:"TotalNum"`
	PageIndex int        `json:"PageIndex" xml:"PageIndex"`
	PageNum   int        `json:"PageNum" xml:"PageNum"`
	RequestId string     `json:"RequestId" xml:"RequestId"`
	Data      []DataItem `json:"Data" xml:"Data"`
}

// CreateGetOcJusticeExecutedRequest creates a request to invoke GetOcJusticeExecuted API
func CreateGetOcJusticeExecutedRequest() (request *GetOcJusticeExecutedRequest) {
	request = &GetOcJusticeExecutedRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dt-oc-info", "2022-08-29", "GetOcJusticeExecuted", "", "")
	request.Method = requests.POST
	return
}

// CreateGetOcJusticeExecutedResponse creates a response to parse from GetOcJusticeExecuted response
func CreateGetOcJusticeExecutedResponse() (response *GetOcJusticeExecutedResponse) {
	response = &GetOcJusticeExecutedResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
