package ecd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ConfigADConnectorUser invokes the ecd.ConfigADConnectorUser API synchronously
func (client *Client) ConfigADConnectorUser(request *ConfigADConnectorUserRequest) (response *ConfigADConnectorUserResponse, err error) {
	response = CreateConfigADConnectorUserResponse()
	err = client.DoAction(request, response)
	return
}

// ConfigADConnectorUserWithChan invokes the ecd.ConfigADConnectorUser API asynchronously
func (client *Client) ConfigADConnectorUserWithChan(request *ConfigADConnectorUserRequest) (<-chan *ConfigADConnectorUserResponse, <-chan error) {
	responseChan := make(chan *ConfigADConnectorUserResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ConfigADConnectorUser(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ConfigADConnectorUserWithCallback invokes the ecd.ConfigADConnectorUser API asynchronously
func (client *Client) ConfigADConnectorUserWithCallback(request *ConfigADConnectorUserRequest, callback func(response *ConfigADConnectorUserResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ConfigADConnectorUserResponse
		var err error
		defer close(result)
		response, err = client.ConfigADConnectorUser(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ConfigADConnectorUserRequest is the request struct for api ConfigADConnectorUser
type ConfigADConnectorUserRequest struct {
	*requests.RpcRequest
	OfficeSiteId   string `position:"Query" name:"OfficeSiteId"`
	DomainPassword string `position:"Query" name:"DomainPassword"`
	DomainUserName string `position:"Query" name:"DomainUserName"`
	OUName         string `position:"Query" name:"OUName"`
}

// ConfigADConnectorUserResponse is the response struct for api ConfigADConnectorUser
type ConfigADConnectorUserResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateConfigADConnectorUserRequest creates a request to invoke ConfigADConnectorUser API
func CreateConfigADConnectorUserRequest() (request *ConfigADConnectorUserRequest) {
	request = &ConfigADConnectorUserRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecd", "2020-09-30", "ConfigADConnectorUser", "gwsecd", "openAPI")
	request.Method = requests.POST
	return
}

// CreateConfigADConnectorUserResponse creates a response to parse from ConfigADConnectorUser response
func CreateConfigADConnectorUserResponse() (response *ConfigADConnectorUserResponse) {
	response = &ConfigADConnectorUserResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
