package ecd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListOfficeSiteOverview invokes the ecd.ListOfficeSiteOverview API synchronously
func (client *Client) ListOfficeSiteOverview(request *ListOfficeSiteOverviewRequest) (response *ListOfficeSiteOverviewResponse, err error) {
	response = CreateListOfficeSiteOverviewResponse()
	err = client.DoAction(request, response)
	return
}

// ListOfficeSiteOverviewWithChan invokes the ecd.ListOfficeSiteOverview API asynchronously
func (client *Client) ListOfficeSiteOverviewWithChan(request *ListOfficeSiteOverviewRequest) (<-chan *ListOfficeSiteOverviewResponse, <-chan error) {
	responseChan := make(chan *ListOfficeSiteOverviewResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListOfficeSiteOverview(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListOfficeSiteOverviewWithCallback invokes the ecd.ListOfficeSiteOverview API asynchronously
func (client *Client) ListOfficeSiteOverviewWithCallback(request *ListOfficeSiteOverviewRequest, callback func(response *ListOfficeSiteOverviewResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListOfficeSiteOverviewResponse
		var err error
		defer close(result)
		response, err = client.ListOfficeSiteOverview(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListOfficeSiteOverviewRequest is the request struct for api ListOfficeSiteOverview
type ListOfficeSiteOverviewRequest struct {
	*requests.RpcRequest
	OfficeSiteId *[]string        `position:"Query" name:"OfficeSiteId"  type:"Repeated"`
	QueryRange   requests.Integer `position:"Query" name:"QueryRange"`
	ForceRefresh requests.Boolean `position:"Query" name:"ForceRefresh"`
	NextToken    string           `position:"Query" name:"NextToken"`
	MaxResults   requests.Integer `position:"Query" name:"MaxResults"`
}

// ListOfficeSiteOverviewResponse is the response struct for api ListOfficeSiteOverview
type ListOfficeSiteOverviewResponse struct {
	*responses.BaseResponse
	NextToken                 string                     `json:"NextToken" xml:"NextToken"`
	RequestId                 string                     `json:"RequestId" xml:"RequestId"`
	OfficeSiteOverviewResults []OfficeSiteOverviewResult `json:"OfficeSiteOverviewResults" xml:"OfficeSiteOverviewResults"`
}

// CreateListOfficeSiteOverviewRequest creates a request to invoke ListOfficeSiteOverview API
func CreateListOfficeSiteOverviewRequest() (request *ListOfficeSiteOverviewRequest) {
	request = &ListOfficeSiteOverviewRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecd", "2020-09-30", "ListOfficeSiteOverview", "gwsecd", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListOfficeSiteOverviewResponse creates a response to parse from ListOfficeSiteOverview response
func CreateListOfficeSiteOverviewResponse() (response *ListOfficeSiteOverviewResponse) {
	response = &ListOfficeSiteOverviewResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
