package ecd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyDesktopOversoldUserGroup invokes the ecd.ModifyDesktopOversoldUserGroup API synchronously
func (client *Client) ModifyDesktopOversoldUserGroup(request *ModifyDesktopOversoldUserGroupRequest) (response *ModifyDesktopOversoldUserGroupResponse, err error) {
	response = CreateModifyDesktopOversoldUserGroupResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyDesktopOversoldUserGroupWithChan invokes the ecd.ModifyDesktopOversoldUserGroup API asynchronously
func (client *Client) ModifyDesktopOversoldUserGroupWithChan(request *ModifyDesktopOversoldUserGroupRequest) (<-chan *ModifyDesktopOversoldUserGroupResponse, <-chan error) {
	responseChan := make(chan *ModifyDesktopOversoldUserGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyDesktopOversoldUserGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyDesktopOversoldUserGroupWithCallback invokes the ecd.ModifyDesktopOversoldUserGroup API asynchronously
func (client *Client) ModifyDesktopOversoldUserGroupWithCallback(request *ModifyDesktopOversoldUserGroupRequest, callback func(response *ModifyDesktopOversoldUserGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyDesktopOversoldUserGroupResponse
		var err error
		defer close(result)
		response, err = client.ModifyDesktopOversoldUserGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyDesktopOversoldUserGroupRequest is the request struct for api ModifyDesktopOversoldUserGroup
type ModifyDesktopOversoldUserGroupRequest struct {
	*requests.RpcRequest
	OversoldGroupId string `position:"Query" name:"OversoldGroupId"`
	ImageId         string `position:"Query" name:"ImageId"`
	UserGroupId     string `position:"Query" name:"UserGroupId"`
	Name            string `position:"Query" name:"Name"`
	PolicyGroupId   string `position:"Query" name:"PolicyGroupId"`
}

// ModifyDesktopOversoldUserGroupResponse is the response struct for api ModifyDesktopOversoldUserGroup
type ModifyDesktopOversoldUserGroupResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateModifyDesktopOversoldUserGroupRequest creates a request to invoke ModifyDesktopOversoldUserGroup API
func CreateModifyDesktopOversoldUserGroupRequest() (request *ModifyDesktopOversoldUserGroupRequest) {
	request = &ModifyDesktopOversoldUserGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecd", "2020-09-30", "ModifyDesktopOversoldUserGroup", "gwsecd", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyDesktopOversoldUserGroupResponse creates a response to parse from ModifyDesktopOversoldUserGroup response
func CreateModifyDesktopOversoldUserGroupResponse() (response *ModifyDesktopOversoldUserGroupResponse) {
	response = &ModifyDesktopOversoldUserGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
