package ecd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RenewDesktopOversoldGroup invokes the ecd.RenewDesktopOversoldGroup API synchronously
func (client *Client) RenewDesktopOversoldGroup(request *RenewDesktopOversoldGroupRequest) (response *RenewDesktopOversoldGroupResponse, err error) {
	response = CreateRenewDesktopOversoldGroupResponse()
	err = client.DoAction(request, response)
	return
}

// RenewDesktopOversoldGroupWithChan invokes the ecd.RenewDesktopOversoldGroup API asynchronously
func (client *Client) RenewDesktopOversoldGroupWithChan(request *RenewDesktopOversoldGroupRequest) (<-chan *RenewDesktopOversoldGroupResponse, <-chan error) {
	responseChan := make(chan *RenewDesktopOversoldGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RenewDesktopOversoldGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RenewDesktopOversoldGroupWithCallback invokes the ecd.RenewDesktopOversoldGroup API asynchronously
func (client *Client) RenewDesktopOversoldGroupWithCallback(request *RenewDesktopOversoldGroupRequest, callback func(response *RenewDesktopOversoldGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RenewDesktopOversoldGroupResponse
		var err error
		defer close(result)
		response, err = client.RenewDesktopOversoldGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RenewDesktopOversoldGroupRequest is the request struct for api RenewDesktopOversoldGroup
type RenewDesktopOversoldGroupRequest struct {
	*requests.RpcRequest
	Period          requests.Integer `position:"Query" name:"Period"`
	OversoldGroupId string           `position:"Query" name:"OversoldGroupId"`
	PeriodUnit      string           `position:"Query" name:"PeriodUnit"`
}

// RenewDesktopOversoldGroupResponse is the response struct for api RenewDesktopOversoldGroup
type RenewDesktopOversoldGroupResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateRenewDesktopOversoldGroupRequest creates a request to invoke RenewDesktopOversoldGroup API
func CreateRenewDesktopOversoldGroupRequest() (request *RenewDesktopOversoldGroupRequest) {
	request = &RenewDesktopOversoldGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecd", "2020-09-30", "RenewDesktopOversoldGroup", "gwsecd", "openAPI")
	request.Method = requests.POST
	return
}

// CreateRenewDesktopOversoldGroupResponse creates a response to parse from RenewDesktopOversoldGroup response
func CreateRenewDesktopOversoldGroupResponse() (response *RenewDesktopOversoldGroupResponse) {
	response = &RenewDesktopOversoldGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
