package edas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QuerySlsLogStoreList invokes the edas.QuerySlsLogStoreList API synchronously
func (client *Client) QuerySlsLogStoreList(request *QuerySlsLogStoreListRequest) (response *QuerySlsLogStoreListResponse, err error) {
	response = CreateQuerySlsLogStoreListResponse()
	err = client.DoAction(request, response)
	return
}

// QuerySlsLogStoreListWithChan invokes the edas.QuerySlsLogStoreList API asynchronously
func (client *Client) QuerySlsLogStoreListWithChan(request *QuerySlsLogStoreListRequest) (<-chan *QuerySlsLogStoreListResponse, <-chan error) {
	responseChan := make(chan *QuerySlsLogStoreListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QuerySlsLogStoreList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QuerySlsLogStoreListWithCallback invokes the edas.QuerySlsLogStoreList API asynchronously
func (client *Client) QuerySlsLogStoreListWithCallback(request *QuerySlsLogStoreListRequest, callback func(response *QuerySlsLogStoreListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QuerySlsLogStoreListResponse
		var err error
		defer close(result)
		response, err = client.QuerySlsLogStoreList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QuerySlsLogStoreListRequest is the request struct for api QuerySlsLogStoreList
type QuerySlsLogStoreListRequest struct {
	*requests.RoaRequest
	AppId       string           `position:"Query" name:"AppId"`
	PageSize    requests.Integer `position:"Query" name:"PageSize"`
	CurrentPage requests.Integer `position:"Query" name:"CurrentPage"`
	Type        string           `position:"Query" name:"Type"`
}

// QuerySlsLogStoreListResponse is the response struct for api QuerySlsLogStoreList
type QuerySlsLogStoreListResponse struct {
	*responses.BaseResponse
	Code      int      `json:"Code" xml:"Code"`
	Message   string   `json:"Message" xml:"Message"`
	RequestId string   `json:"RequestId" xml:"RequestId"`
	TotalSize int      `json:"TotalSize" xml:"TotalSize"`
	Result    []SlsLog `json:"Result" xml:"Result"`
}

// CreateQuerySlsLogStoreListRequest creates a request to invoke QuerySlsLogStoreList API
func CreateQuerySlsLogStoreListRequest() (request *QuerySlsLogStoreListRequest) {
	request = &QuerySlsLogStoreListRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Edas", "2017-08-01", "QuerySlsLogStoreList", "/pop/v5/k8s/sls/query_sls_log_store_list", "Edas", "openAPI")
	request.Method = requests.GET
	return
}

// CreateQuerySlsLogStoreListResponse creates a response to parse from QuerySlsLogStoreList response
func CreateQuerySlsLogStoreListResponse() (response *QuerySlsLogStoreListResponse) {
	response = &QuerySlsLogStoreListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
