package edas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateK8sSecret invokes the edas.UpdateK8sSecret API synchronously
func (client *Client) UpdateK8sSecret(request *UpdateK8sSecretRequest) (response *UpdateK8sSecretResponse, err error) {
	response = CreateUpdateK8sSecretResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateK8sSecretWithChan invokes the edas.UpdateK8sSecret API asynchronously
func (client *Client) UpdateK8sSecretWithChan(request *UpdateK8sSecretRequest) (<-chan *UpdateK8sSecretResponse, <-chan error) {
	responseChan := make(chan *UpdateK8sSecretResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateK8sSecret(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateK8sSecretWithCallback invokes the edas.UpdateK8sSecret API asynchronously
func (client *Client) UpdateK8sSecretWithCallback(request *UpdateK8sSecretRequest, callback func(response *UpdateK8sSecretResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateK8sSecretResponse
		var err error
		defer close(result)
		response, err = client.UpdateK8sSecret(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateK8sSecretRequest is the request struct for api UpdateK8sSecret
type UpdateK8sSecretRequest struct {
	*requests.RoaRequest
	Base64Encoded requests.Boolean `position:"Body" name:"Base64Encoded"`
	Data          string           `position:"Body" name:"Data"`
	Name          string           `position:"Body" name:"Name"`
	Namespace     string           `position:"Body" name:"Namespace"`
	ClusterId     string           `position:"Body" name:"ClusterId"`
	CertId        string           `position:"Body" name:"CertId"`
	Type          string           `position:"Body" name:"Type"`
	CertRegionId  string           `position:"Body" name:"CertRegionId"`
}

// UpdateK8sSecretResponse is the response struct for api UpdateK8sSecret
type UpdateK8sSecretResponse struct {
	*responses.BaseResponse
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateK8sSecretRequest creates a request to invoke UpdateK8sSecret API
func CreateUpdateK8sSecretRequest() (request *UpdateK8sSecretRequest) {
	request = &UpdateK8sSecretRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Edas", "2017-08-01", "UpdateK8sSecret", "/pop/v5/k8s/acs/k8s_secret", "Edas", "openAPI")
	request.Method = requests.PUT
	return
}

// CreateUpdateK8sSecretResponse creates a response to parse from UpdateK8sSecret response
func CreateUpdateK8sSecretResponse() (response *UpdateK8sSecretResponse) {
	response = &UpdateK8sSecretResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
