package eflo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteElasticNetworkInterface invokes the eflo.DeleteElasticNetworkInterface API synchronously
func (client *Client) DeleteElasticNetworkInterface(request *DeleteElasticNetworkInterfaceRequest) (response *DeleteElasticNetworkInterfaceResponse, err error) {
	response = CreateDeleteElasticNetworkInterfaceResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteElasticNetworkInterfaceWithChan invokes the eflo.DeleteElasticNetworkInterface API asynchronously
func (client *Client) DeleteElasticNetworkInterfaceWithChan(request *DeleteElasticNetworkInterfaceRequest) (<-chan *DeleteElasticNetworkInterfaceResponse, <-chan error) {
	responseChan := make(chan *DeleteElasticNetworkInterfaceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteElasticNetworkInterface(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteElasticNetworkInterfaceWithCallback invokes the eflo.DeleteElasticNetworkInterface API asynchronously
func (client *Client) DeleteElasticNetworkInterfaceWithCallback(request *DeleteElasticNetworkInterfaceRequest, callback func(response *DeleteElasticNetworkInterfaceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteElasticNetworkInterfaceResponse
		var err error
		defer close(result)
		response, err = client.DeleteElasticNetworkInterface(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteElasticNetworkInterfaceRequest is the request struct for api DeleteElasticNetworkInterface
type DeleteElasticNetworkInterfaceRequest struct {
	*requests.RpcRequest
	ClientToken               string `position:"Body" name:"ClientToken"`
	ElasticNetworkInterfaceId string `position:"Body" name:"ElasticNetworkInterfaceId"`
}

// DeleteElasticNetworkInterfaceResponse is the response struct for api DeleteElasticNetworkInterface
type DeleteElasticNetworkInterfaceResponse struct {
	*responses.BaseResponse
	Code      int     `json:"Code" xml:"Code"`
	Message   string  `json:"Message" xml:"Message"`
	RequestId string  `json:"RequestId" xml:"RequestId"`
	Content   Content `json:"Content" xml:"Content"`
}

// CreateDeleteElasticNetworkInterfaceRequest creates a request to invoke DeleteElasticNetworkInterface API
func CreateDeleteElasticNetworkInterfaceRequest() (request *DeleteElasticNetworkInterfaceRequest) {
	request = &DeleteElasticNetworkInterfaceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("eflo", "2022-05-30", "DeleteElasticNetworkInterface", "eflo", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteElasticNetworkInterfaceResponse creates a response to parse from DeleteElasticNetworkInterface response
func CreateDeleteElasticNetworkInterfaceResponse() (response *DeleteElasticNetworkInterfaceResponse) {
	response = &DeleteElasticNetworkInterfaceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
