package eflo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetFabricTopology invokes the eflo.GetFabricTopology API synchronously
func (client *Client) GetFabricTopology(request *GetFabricTopologyRequest) (response *GetFabricTopologyResponse, err error) {
	response = CreateGetFabricTopologyResponse()
	err = client.DoAction(request, response)
	return
}

// GetFabricTopologyWithChan invokes the eflo.GetFabricTopology API asynchronously
func (client *Client) GetFabricTopologyWithChan(request *GetFabricTopologyRequest) (<-chan *GetFabricTopologyResponse, <-chan error) {
	responseChan := make(chan *GetFabricTopologyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetFabricTopology(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetFabricTopologyWithCallback invokes the eflo.GetFabricTopology API asynchronously
func (client *Client) GetFabricTopologyWithCallback(request *GetFabricTopologyRequest, callback func(response *GetFabricTopologyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetFabricTopologyResponse
		var err error
		defer close(result)
		response, err = client.GetFabricTopology(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetFabricTopologyRequest is the request struct for api GetFabricTopology
type GetFabricTopologyRequest struct {
	*requests.RpcRequest
	ClusterId string    `position:"Body" name:"ClusterId"`
	VpdId     string    `position:"Body" name:"VpdId"`
	VpcId     string    `position:"Body" name:"VpcId"`
	LniIds    *[]string `position:"Body" name:"LniIds"  type:"Repeated"`
	NodeIds   *[]string `position:"Body" name:"NodeIds"  type:"Repeated"`
}

// GetFabricTopologyResponse is the response struct for api GetFabricTopology
type GetFabricTopologyResponse struct {
	*responses.BaseResponse
	Code      int     `json:"Code" xml:"Code"`
	Message   string  `json:"Message" xml:"Message"`
	RequestId string  `json:"RequestId" xml:"RequestId"`
	Content   Content `json:"Content" xml:"Content"`
}

// CreateGetFabricTopologyRequest creates a request to invoke GetFabricTopology API
func CreateGetFabricTopologyRequest() (request *GetFabricTopologyRequest) {
	request = &GetFabricTopologyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("eflo", "2022-05-30", "GetFabricTopology", "eflo", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetFabricTopologyResponse creates a response to parse from GetFabricTopology response
func CreateGetFabricTopologyResponse() (response *GetFabricTopologyResponse) {
	response = &GetFabricTopologyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
