package eflo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListErRouteMaps invokes the eflo.ListErRouteMaps API synchronously
func (client *Client) ListErRouteMaps(request *ListErRouteMapsRequest) (response *ListErRouteMapsResponse, err error) {
	response = CreateListErRouteMapsResponse()
	err = client.DoAction(request, response)
	return
}

// ListErRouteMapsWithChan invokes the eflo.ListErRouteMaps API asynchronously
func (client *Client) ListErRouteMapsWithChan(request *ListErRouteMapsRequest) (<-chan *ListErRouteMapsResponse, <-chan error) {
	responseChan := make(chan *ListErRouteMapsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListErRouteMaps(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListErRouteMapsWithCallback invokes the eflo.ListErRouteMaps API asynchronously
func (client *Client) ListErRouteMapsWithCallback(request *ListErRouteMapsRequest, callback func(response *ListErRouteMapsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListErRouteMapsResponse
		var err error
		defer close(result)
		response, err = client.ListErRouteMaps(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListErRouteMapsRequest is the request struct for api ListErRouteMaps
type ListErRouteMapsRequest struct {
	*requests.RpcRequest
	ReceptionInstanceType    string           `position:"Body" name:"ReceptionInstanceType"`
	ReceptionInstanceId      string           `position:"Body" name:"ReceptionInstanceId"`
	ErRouteMapNum            requests.Integer `position:"Body" name:"ErRouteMapNum"`
	PageNumber               requests.Integer `position:"Body" name:"PageNumber"`
	ResourceGroupId          string           `position:"Body" name:"ResourceGroupId"`
	RouteMapAction           string           `position:"Body" name:"RouteMapAction"`
	TransmissionInstanceType string           `position:"Body" name:"TransmissionInstanceType"`
	PageSize                 requests.Integer `position:"Body" name:"PageSize"`
	TransmissionInstanceName string           `position:"Body" name:"TransmissionInstanceName"`
	DestinationCidrBlock     string           `position:"Body" name:"DestinationCidrBlock"`
	ErId                     string           `position:"Body" name:"ErId"`
	ErRouteMapId             string           `position:"Body" name:"ErRouteMapId"`
	ReceptionInstanceName    string           `position:"Body" name:"ReceptionInstanceName"`
	EnablePage               requests.Boolean `position:"Body" name:"EnablePage"`
	TransmissionInstanceId   string           `position:"Body" name:"TransmissionInstanceId"`
}

// ListErRouteMapsResponse is the response struct for api ListErRouteMaps
type ListErRouteMapsResponse struct {
	*responses.BaseResponse
	Code      int     `json:"Code" xml:"Code"`
	Message   string  `json:"Message" xml:"Message"`
	RequestId string  `json:"RequestId" xml:"RequestId"`
	Content   Content `json:"Content" xml:"Content"`
}

// CreateListErRouteMapsRequest creates a request to invoke ListErRouteMaps API
func CreateListErRouteMapsRequest() (request *ListErRouteMapsRequest) {
	request = &ListErRouteMapsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("eflo", "2022-05-30", "ListErRouteMaps", "eflo", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListErRouteMapsResponse creates a response to parse from ListErRouteMaps response
func CreateListErRouteMapsResponse() (response *ListErRouteMapsResponse) {
	response = &ListErRouteMapsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
