package eflo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListLeniPrivateIpAddresses invokes the eflo.ListLeniPrivateIpAddresses API synchronously
func (client *Client) ListLeniPrivateIpAddresses(request *ListLeniPrivateIpAddressesRequest) (response *ListLeniPrivateIpAddressesResponse, err error) {
	response = CreateListLeniPrivateIpAddressesResponse()
	err = client.DoAction(request, response)
	return
}

// ListLeniPrivateIpAddressesWithChan invokes the eflo.ListLeniPrivateIpAddresses API asynchronously
func (client *Client) ListLeniPrivateIpAddressesWithChan(request *ListLeniPrivateIpAddressesRequest) (<-chan *ListLeniPrivateIpAddressesResponse, <-chan error) {
	responseChan := make(chan *ListLeniPrivateIpAddressesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListLeniPrivateIpAddresses(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListLeniPrivateIpAddressesWithCallback invokes the eflo.ListLeniPrivateIpAddresses API asynchronously
func (client *Client) ListLeniPrivateIpAddressesWithCallback(request *ListLeniPrivateIpAddressesRequest, callback func(response *ListLeniPrivateIpAddressesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListLeniPrivateIpAddressesResponse
		var err error
		defer close(result)
		response, err = client.ListLeniPrivateIpAddresses(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListLeniPrivateIpAddressesRequest is the request struct for api ListLeniPrivateIpAddresses
type ListLeniPrivateIpAddressesRequest struct {
	*requests.RpcRequest
	PageNumber                requests.Integer `position:"Body" name:"PageNumber"`
	PageSize                  requests.Integer `position:"Body" name:"PageSize"`
	PrivateIpAddress          string           `position:"Body" name:"PrivateIpAddress"`
	IpName                    string           `position:"Body" name:"IpName"`
	ElasticNetworkInterfaceId string           `position:"Body" name:"ElasticNetworkInterfaceId"`
	Status                    string           `position:"Body" name:"Status"`
}

// ListLeniPrivateIpAddressesResponse is the response struct for api ListLeniPrivateIpAddresses
type ListLeniPrivateIpAddressesResponse struct {
	*responses.BaseResponse
	Code      int     `json:"Code" xml:"Code"`
	Message   string  `json:"Message" xml:"Message"`
	RequestId string  `json:"RequestId" xml:"RequestId"`
	Content   Content `json:"Content" xml:"Content"`
}

// CreateListLeniPrivateIpAddressesRequest creates a request to invoke ListLeniPrivateIpAddresses API
func CreateListLeniPrivateIpAddressesRequest() (request *ListLeniPrivateIpAddressesRequest) {
	request = &ListLeniPrivateIpAddressesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("eflo", "2022-05-30", "ListLeniPrivateIpAddresses", "eflo", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListLeniPrivateIpAddressesResponse creates a response to parse from ListLeniPrivateIpAddresses response
func CreateListLeniPrivateIpAddressesResponse() (response *ListLeniPrivateIpAddressesResponse) {
	response = &ListLeniPrivateIpAddressesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
