package ens

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateEnsSaleControl invokes the ens.CreateEnsSaleControl API synchronously
func (client *Client) CreateEnsSaleControl(request *CreateEnsSaleControlRequest) (response *CreateEnsSaleControlResponse, err error) {
	response = CreateCreateEnsSaleControlResponse()
	err = client.DoAction(request, response)
	return
}

// CreateEnsSaleControlWithChan invokes the ens.CreateEnsSaleControl API asynchronously
func (client *Client) CreateEnsSaleControlWithChan(request *CreateEnsSaleControlRequest) (<-chan *CreateEnsSaleControlResponse, <-chan error) {
	responseChan := make(chan *CreateEnsSaleControlResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateEnsSaleControl(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateEnsSaleControlWithCallback invokes the ens.CreateEnsSaleControl API asynchronously
func (client *Client) CreateEnsSaleControlWithCallback(request *CreateEnsSaleControlRequest, callback func(response *CreateEnsSaleControlResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateEnsSaleControlResponse
		var err error
		defer close(result)
		response, err = client.CreateEnsSaleControl(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateEnsSaleControlRequest is the request struct for api CreateEnsSaleControl
type CreateEnsSaleControlRequest struct {
	*requests.RpcRequest
	SaleControls  *[]CreateEnsSaleControlSaleControls `position:"Query" name:"SaleControls"  type:"Json"`
	CustomAccount string                              `position:"Query" name:"CustomAccount"`
	CommodityCode string                              `position:"Query" name:"CommodityCode"`
	AliUidAccount string                              `position:"Query" name:"AliUidAccount"`
}

// CreateEnsSaleControlSaleControls is a repeated param struct in CreateEnsSaleControlRequest
type CreateEnsSaleControlSaleControls struct {
	ModuleCode        string                                                   `name:"ModuleCode"`
	ModuleValue       CreateEnsSaleControlSaleControlsModuleValue              `name:"ModuleValue" type:"Struct"`
	ConditionControls *[]CreateEnsSaleControlSaleControlsConditionControlsItem `name:"ConditionControls" type:"Repeated"`
	Description       string                                                   `name:"Description"`
	Operator          string                                                   `name:"Operator"`
	OrderType         string                                                   `name:"OrderType"`
}

// CreateEnsSaleControlSaleControlsModuleValue is a repeated param struct in CreateEnsSaleControlRequest
type CreateEnsSaleControlSaleControlsModuleValue struct {
	ModuleValue    *[]string `name:"ModuleValue" type:"Repeated"`
	ModuleMaxValue string    `name:"ModuleMaxValue"`
	ModuleMinValue string    `name:"ModuleMinValue"`
}

// CreateEnsSaleControlSaleControlsConditionControlsItem is a repeated param struct in CreateEnsSaleControlRequest
type CreateEnsSaleControlSaleControlsConditionControlsItem struct {
	ConditionControlModuleValue string `name:"ConditionControlModuleValue"`
	ConditionControlModuleCode  string `name:"ConditionControlModuleCode"`
}

// CreateEnsSaleControlResponse is the response struct for api CreateEnsSaleControl
type CreateEnsSaleControlResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateCreateEnsSaleControlRequest creates a request to invoke CreateEnsSaleControl API
func CreateCreateEnsSaleControlRequest() (request *CreateEnsSaleControlRequest) {
	request = &CreateEnsSaleControlRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ens", "2017-11-10", "CreateEnsSaleControl", "ens", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateEnsSaleControlResponse creates a response to parse from CreateEnsSaleControl response
func CreateCreateEnsSaleControlResponse() (response *CreateEnsSaleControlResponse) {
	response = &CreateEnsSaleControlResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
