package ens

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteEip invokes the ens.DeleteEip API synchronously
func (client *Client) DeleteEip(request *DeleteEipRequest) (response *DeleteEipResponse, err error) {
	response = CreateDeleteEipResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteEipWithChan invokes the ens.DeleteEip API asynchronously
func (client *Client) DeleteEipWithChan(request *DeleteEipRequest) (<-chan *DeleteEipResponse, <-chan error) {
	responseChan := make(chan *DeleteEipResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteEip(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteEipWithCallback invokes the ens.DeleteEip API asynchronously
func (client *Client) DeleteEipWithCallback(request *DeleteEipRequest, callback func(response *DeleteEipResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteEipResponse
		var err error
		defer close(result)
		response, err = client.DeleteEip(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteEipRequest is the request struct for api DeleteEip
type DeleteEipRequest struct {
	*requests.RpcRequest
	InstanceId string `position:"Query" name:"InstanceId"`
}

// DeleteEipResponse is the response struct for api DeleteEip
type DeleteEipResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteEipRequest creates a request to invoke DeleteEip API
func CreateDeleteEipRequest() (request *DeleteEipRequest) {
	request = &DeleteEipRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ens", "2017-11-10", "DeleteEip", "ens", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteEipResponse creates a response to parse from DeleteEip response
func CreateDeleteEipResponse() (response *DeleteEipResponse) {
	response = &DeleteEipResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
