package ens

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeEnsCommodityModuleCode invokes the ens.DescribeEnsCommodityModuleCode API synchronously
func (client *Client) DescribeEnsCommodityModuleCode(request *DescribeEnsCommodityModuleCodeRequest) (response *DescribeEnsCommodityModuleCodeResponse, err error) {
	response = CreateDescribeEnsCommodityModuleCodeResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeEnsCommodityModuleCodeWithChan invokes the ens.DescribeEnsCommodityModuleCode API asynchronously
func (client *Client) DescribeEnsCommodityModuleCodeWithChan(request *DescribeEnsCommodityModuleCodeRequest) (<-chan *DescribeEnsCommodityModuleCodeResponse, <-chan error) {
	responseChan := make(chan *DescribeEnsCommodityModuleCodeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeEnsCommodityModuleCode(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeEnsCommodityModuleCodeWithCallback invokes the ens.DescribeEnsCommodityModuleCode API asynchronously
func (client *Client) DescribeEnsCommodityModuleCodeWithCallback(request *DescribeEnsCommodityModuleCodeRequest, callback func(response *DescribeEnsCommodityModuleCodeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeEnsCommodityModuleCodeResponse
		var err error
		defer close(result)
		response, err = client.DescribeEnsCommodityModuleCode(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeEnsCommodityModuleCodeRequest is the request struct for api DescribeEnsCommodityModuleCode
type DescribeEnsCommodityModuleCodeRequest struct {
	*requests.RpcRequest
	CommodityCode string `position:"Query" name:"CommodityCode"`
	ModuleCode    string `position:"Query" name:"ModuleCode"`
}

// DescribeEnsCommodityModuleCodeResponse is the response struct for api DescribeEnsCommodityModuleCode
type DescribeEnsCommodityModuleCodeResponse struct {
	*responses.BaseResponse
	RequestId          string                   `json:"RequestId" xml:"RequestId"`
	CommodityCodesInfo []CommodityCodesInfoItem `json:"CommodityCodesInfo" xml:"CommodityCodesInfo"`
}

// CreateDescribeEnsCommodityModuleCodeRequest creates a request to invoke DescribeEnsCommodityModuleCode API
func CreateDescribeEnsCommodityModuleCodeRequest() (request *DescribeEnsCommodityModuleCodeRequest) {
	request = &DescribeEnsCommodityModuleCodeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ens", "2017-11-10", "DescribeEnsCommodityModuleCode", "ens", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeEnsCommodityModuleCodeResponse creates a response to parse from DescribeEnsCommodityModuleCode response
func CreateDescribeEnsCommodityModuleCodeResponse() (response *DescribeEnsCommodityModuleCodeResponse) {
	response = &DescribeEnsCommodityModuleCodeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
