package ens

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// PreloadRegionSDG invokes the ens.PreloadRegionSDG API synchronously
func (client *Client) PreloadRegionSDG(request *PreloadRegionSDGRequest) (response *PreloadRegionSDGResponse, err error) {
	response = CreatePreloadRegionSDGResponse()
	err = client.DoAction(request, response)
	return
}

// PreloadRegionSDGWithChan invokes the ens.PreloadRegionSDG API asynchronously
func (client *Client) PreloadRegionSDGWithChan(request *PreloadRegionSDGRequest) (<-chan *PreloadRegionSDGResponse, <-chan error) {
	responseChan := make(chan *PreloadRegionSDGResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.PreloadRegionSDG(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// PreloadRegionSDGWithCallback invokes the ens.PreloadRegionSDG API asynchronously
func (client *Client) PreloadRegionSDGWithCallback(request *PreloadRegionSDGRequest, callback func(response *PreloadRegionSDGResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *PreloadRegionSDGResponse
		var err error
		defer close(result)
		response, err = client.PreloadRegionSDG(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// PreloadRegionSDGRequest is the request struct for api PreloadRegionSDG
type PreloadRegionSDGRequest struct {
	*requests.RpcRequest
	DestinationRegionIds *[]string        `position:"Query" name:"DestinationRegionIds"  type:"Json"`
	SDGId                string           `position:"Query" name:"SDGId"`
	RedundantNum         requests.Integer `position:"Query" name:"RedundantNum"`
	Namespaces           *[]string        `position:"Query" name:"Namespaces"  type:"Json"`
}

// PreloadRegionSDGResponse is the response struct for api PreloadRegionSDG
type PreloadRegionSDGResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreatePreloadRegionSDGRequest creates a request to invoke PreloadRegionSDG API
func CreatePreloadRegionSDGRequest() (request *PreloadRegionSDGRequest) {
	request = &PreloadRegionSDGRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ens", "2017-11-10", "PreloadRegionSDG", "ens", "openAPI")
	request.Method = requests.POST
	return
}

// CreatePreloadRegionSDGResponse creates a response to parse from PreloadRegionSDG response
func CreatePreloadRegionSDGResponse() (response *PreloadRegionSDGResponse) {
	response = &PreloadRegionSDGResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
