package gpdb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryCollectionData invokes the gpdb.QueryCollectionData API synchronously
func (client *Client) QueryCollectionData(request *QueryCollectionDataRequest) (response *QueryCollectionDataResponse, err error) {
	response = CreateQueryCollectionDataResponse()
	err = client.DoAction(request, response)
	return
}

// QueryCollectionDataWithChan invokes the gpdb.QueryCollectionData API asynchronously
func (client *Client) QueryCollectionDataWithChan(request *QueryCollectionDataRequest) (<-chan *QueryCollectionDataResponse, <-chan error) {
	responseChan := make(chan *QueryCollectionDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryCollectionData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryCollectionDataWithCallback invokes the gpdb.QueryCollectionData API asynchronously
func (client *Client) QueryCollectionDataWithCallback(request *QueryCollectionDataRequest, callback func(response *QueryCollectionDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryCollectionDataResponse
		var err error
		defer close(result)
		response, err = client.QueryCollectionData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryCollectionDataRequest is the request struct for api QueryCollectionData
type QueryCollectionDataRequest struct {
	*requests.RpcRequest
	TopK              requests.Integer `position:"Query" name:"TopK"`
	Content           string           `position:"Query" name:"Content"`
	DBInstanceId      string           `position:"Query" name:"DBInstanceId"`
	Vector            *[]string        `position:"Query" name:"Vector"  type:"Json"`
	Collection        string           `position:"Query" name:"Collection"`
	OwnerId           requests.Integer `position:"Query" name:"OwnerId"`
	NamespacePassword string           `position:"Query" name:"NamespacePassword"`
	Filter            string           `position:"Query" name:"Filter"`
	Namespace         string           `position:"Query" name:"Namespace"`
}

// QueryCollectionDataResponse is the response struct for api QueryCollectionData
type QueryCollectionDataResponse struct {
	*responses.BaseResponse
	RequestId string  `json:"RequestId" xml:"RequestId"`
	Status    string  `json:"Status" xml:"Status"`
	Message   string  `json:"Message" xml:"Message"`
	Matches   Matches `json:"Matches" xml:"Matches"`
}

// CreateQueryCollectionDataRequest creates a request to invoke QueryCollectionData API
func CreateQueryCollectionDataRequest() (request *QueryCollectionDataRequest) {
	request = &QueryCollectionDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("gpdb", "2016-05-03", "QueryCollectionData", "", "")
	request.Method = requests.POST
	return
}

// CreateQueryCollectionDataResponse creates a response to parse from QueryCollectionData response
func CreateQueryCollectionDataResponse() (response *QueryCollectionDataResponse) {
	response = &QueryCollectionDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
