package grace

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AnalyzeFile invokes the grace.AnalyzeFile API synchronously
func (client *Client) AnalyzeFile(request *AnalyzeFileRequest) (response *AnalyzeFileResponse, err error) {
	response = CreateAnalyzeFileResponse()
	err = client.DoAction(request, response)
	return
}

// AnalyzeFileWithChan invokes the grace.AnalyzeFile API asynchronously
func (client *Client) AnalyzeFileWithChan(request *AnalyzeFileRequest) (<-chan *AnalyzeFileResponse, <-chan error) {
	responseChan := make(chan *AnalyzeFileResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AnalyzeFile(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AnalyzeFileWithCallback invokes the grace.AnalyzeFile API asynchronously
func (client *Client) AnalyzeFileWithCallback(request *AnalyzeFileRequest, callback func(response *AnalyzeFileResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AnalyzeFileResponse
		var err error
		defer close(result)
		response, err = client.AnalyzeFile(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AnalyzeFileRequest is the request struct for api AnalyzeFile
type AnalyzeFileRequest struct {
	*requests.RoaRequest
	KeepUnreachableObjects requests.Boolean `position:"Query" name:"keepUnreachableObjects"`
	Token                  string           `position:"Query" name:"token"`
	Name                   string           `position:"Query" name:"name"`
}

// AnalyzeFileResponse is the response struct for api AnalyzeFile
type AnalyzeFileResponse struct {
	*responses.BaseResponse
	RequestId string `json:"requestId" xml:"requestId"`
	FileName  string `json:"fileName" xml:"fileName"`
}

// CreateAnalyzeFileRequest creates a request to invoke AnalyzeFile API
func CreateAnalyzeFileRequest() (request *AnalyzeFileRequest) {
	request = &AnalyzeFileRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("grace", "2022-06-06", "AnalyzeFile", "/AnalyzeFile", "grace", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAnalyzeFileResponse creates a response to parse from AnalyzeFile response
func CreateAnalyzeFileResponse() (response *AnalyzeFileResponse) {
	response = &AnalyzeFileResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
