package grace

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UploadFileByURL invokes the grace.UploadFileByURL API synchronously
func (client *Client) UploadFileByURL(request *UploadFileByURLRequest) (response *UploadFileByURLResponse, err error) {
	response = CreateUploadFileByURLResponse()
	err = client.DoAction(request, response)
	return
}

// UploadFileByURLWithChan invokes the grace.UploadFileByURL API asynchronously
func (client *Client) UploadFileByURLWithChan(request *UploadFileByURLRequest) (<-chan *UploadFileByURLResponse, <-chan error) {
	responseChan := make(chan *UploadFileByURLResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UploadFileByURL(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UploadFileByURLWithCallback invokes the grace.UploadFileByURL API asynchronously
func (client *Client) UploadFileByURLWithCallback(request *UploadFileByURLRequest, callback func(response *UploadFileByURLResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UploadFileByURLResponse
		var err error
		defer close(result)
		response, err = client.UploadFileByURL(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UploadFileByURLRequest is the request struct for api UploadFileByURL
type UploadFileByURLRequest struct {
	*requests.RoaRequest
	Type        string `position:"Query" name:"type"`
	Url         string `position:"Query" name:"url"`
	DisplayName string `position:"Query" name:"displayName"`
}

// UploadFileByURLResponse is the response struct for api UploadFileByURL
type UploadFileByURLResponse struct {
	*responses.BaseResponse
	RequestId string `json:"requestId" xml:"requestId"`
	Name      string `json:"name" xml:"name"`
}

// CreateUploadFileByURLRequest creates a request to invoke UploadFileByURL API
func CreateUploadFileByURLRequest() (request *UploadFileByURLRequest) {
	request = &UploadFileByURLRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("grace", "2022-06-06", "UploadFileByURL", "/UploadFileByURL", "grace", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUploadFileByURLResponse creates a response to parse from UploadFileByURL response
func CreateUploadFileByURLResponse() (response *UploadFileByURLResponse) {
	response = &UploadFileByURLResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
