package idaas_doraemon

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateAuthenticatorRegistration invokes the idaas_doraemon.CreateAuthenticatorRegistration API synchronously
func (client *Client) CreateAuthenticatorRegistration(request *CreateAuthenticatorRegistrationRequest) (response *CreateAuthenticatorRegistrationResponse, err error) {
	response = CreateCreateAuthenticatorRegistrationResponse()
	err = client.DoAction(request, response)
	return
}

// CreateAuthenticatorRegistrationWithChan invokes the idaas_doraemon.CreateAuthenticatorRegistration API asynchronously
func (client *Client) CreateAuthenticatorRegistrationWithChan(request *CreateAuthenticatorRegistrationRequest) (<-chan *CreateAuthenticatorRegistrationResponse, <-chan error) {
	responseChan := make(chan *CreateAuthenticatorRegistrationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateAuthenticatorRegistration(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateAuthenticatorRegistrationWithCallback invokes the idaas_doraemon.CreateAuthenticatorRegistration API asynchronously
func (client *Client) CreateAuthenticatorRegistrationWithCallback(request *CreateAuthenticatorRegistrationRequest, callback func(response *CreateAuthenticatorRegistrationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateAuthenticatorRegistrationResponse
		var err error
		defer close(result)
		response, err = client.CreateAuthenticatorRegistration(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateAuthenticatorRegistrationRequest is the request struct for api CreateAuthenticatorRegistration
type CreateAuthenticatorRegistrationRequest struct {
	*requests.RpcRequest
	ClientExtendParamsJson     string `position:"Query" name:"ClientExtendParamsJson"`
	UserId                     string `position:"Query" name:"UserId"`
	UserDisplayName            string `position:"Query" name:"UserDisplayName"`
	ServerExtendParamsJson     string `position:"Query" name:"ServerExtendParamsJson"`
	RegistrationContext        string `position:"Query" name:"RegistrationContext"`
	AuthenticatorType          string `position:"Query" name:"AuthenticatorType"`
	ClientExtendParamsJsonSign string `position:"Query" name:"ClientExtendParamsJsonSign"`
	ApplicationExternalId      string `position:"Query" name:"ApplicationExternalId"`
	UserName                   string `position:"Query" name:"UserName"`
}

// CreateAuthenticatorRegistrationResponse is the response struct for api CreateAuthenticatorRegistration
type CreateAuthenticatorRegistrationResponse struct {
	*responses.BaseResponse
	RequestId       string `json:"RequestId" xml:"RequestId"`
	ChallengeBase64 string `json:"ChallengeBase64" xml:"ChallengeBase64"`
	Options         string `json:"Options" xml:"Options"`
}

// CreateCreateAuthenticatorRegistrationRequest creates a request to invoke CreateAuthenticatorRegistration API
func CreateCreateAuthenticatorRegistrationRequest() (request *CreateAuthenticatorRegistrationRequest) {
	request = &CreateAuthenticatorRegistrationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("idaas-doraemon", "2021-05-20", "CreateAuthenticatorRegistration", "idaasauth", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateAuthenticatorRegistrationResponse creates a response to parse from CreateAuthenticatorRegistration response
func CreateCreateAuthenticatorRegistrationResponse() (response *CreateAuthenticatorRegistrationResponse) {
	response = &CreateAuthenticatorRegistrationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
