package ims

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GenerateCredentialReport invokes the ims.GenerateCredentialReport API synchronously
func (client *Client) GenerateCredentialReport(request *GenerateCredentialReportRequest) (response *GenerateCredentialReportResponse, err error) {
	response = CreateGenerateCredentialReportResponse()
	err = client.DoAction(request, response)
	return
}

// GenerateCredentialReportWithChan invokes the ims.GenerateCredentialReport API asynchronously
func (client *Client) GenerateCredentialReportWithChan(request *GenerateCredentialReportRequest) (<-chan *GenerateCredentialReportResponse, <-chan error) {
	responseChan := make(chan *GenerateCredentialReportResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GenerateCredentialReport(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GenerateCredentialReportWithCallback invokes the ims.GenerateCredentialReport API asynchronously
func (client *Client) GenerateCredentialReportWithCallback(request *GenerateCredentialReportRequest, callback func(response *GenerateCredentialReportResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GenerateCredentialReportResponse
		var err error
		defer close(result)
		response, err = client.GenerateCredentialReport(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GenerateCredentialReportRequest is the request struct for api GenerateCredentialReport
type GenerateCredentialReportRequest struct {
	*requests.RpcRequest
	AkProxySuffix string `position:"Query" name:"AkProxySuffix"`
}

// GenerateCredentialReportResponse is the response struct for api GenerateCredentialReport
type GenerateCredentialReportResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	State     string `json:"State" xml:"State"`
}

// CreateGenerateCredentialReportRequest creates a request to invoke GenerateCredentialReport API
func CreateGenerateCredentialReportRequest() (request *GenerateCredentialReportRequest) {
	request = &GenerateCredentialReportRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ims", "2019-08-15", "GenerateCredentialReport", "ims", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGenerateCredentialReportResponse creates a response to parse from GenerateCredentialReport response
func CreateGenerateCredentialReportResponse() (response *GenerateCredentialReportResponse) {
	response = &GenerateCredentialReportResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
