package ims

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetAccountSecurityPracticeReport invokes the ims.GetAccountSecurityPracticeReport API synchronously
func (client *Client) GetAccountSecurityPracticeReport(request *GetAccountSecurityPracticeReportRequest) (response *GetAccountSecurityPracticeReportResponse, err error) {
	response = CreateGetAccountSecurityPracticeReportResponse()
	err = client.DoAction(request, response)
	return
}

// GetAccountSecurityPracticeReportWithChan invokes the ims.GetAccountSecurityPracticeReport API asynchronously
func (client *Client) GetAccountSecurityPracticeReportWithChan(request *GetAccountSecurityPracticeReportRequest) (<-chan *GetAccountSecurityPracticeReportResponse, <-chan error) {
	responseChan := make(chan *GetAccountSecurityPracticeReportResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetAccountSecurityPracticeReport(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetAccountSecurityPracticeReportWithCallback invokes the ims.GetAccountSecurityPracticeReport API asynchronously
func (client *Client) GetAccountSecurityPracticeReportWithCallback(request *GetAccountSecurityPracticeReportRequest, callback func(response *GetAccountSecurityPracticeReportResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetAccountSecurityPracticeReportResponse
		var err error
		defer close(result)
		response, err = client.GetAccountSecurityPracticeReport(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetAccountSecurityPracticeReportRequest is the request struct for api GetAccountSecurityPracticeReport
type GetAccountSecurityPracticeReportRequest struct {
	*requests.RpcRequest
	AkProxySuffix string `position:"Query" name:"AkProxySuffix"`
}

// GetAccountSecurityPracticeReportResponse is the response struct for api GetAccountSecurityPracticeReport
type GetAccountSecurityPracticeReportResponse struct {
	*responses.BaseResponse
	RequestId                   string                      `json:"RequestId" xml:"RequestId"`
	AccountSecurityPracticeInfo AccountSecurityPracticeInfo `json:"AccountSecurityPracticeInfo" xml:"AccountSecurityPracticeInfo"`
}

// CreateGetAccountSecurityPracticeReportRequest creates a request to invoke GetAccountSecurityPracticeReport API
func CreateGetAccountSecurityPracticeReportRequest() (request *GetAccountSecurityPracticeReportRequest) {
	request = &GetAccountSecurityPracticeReportRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ims", "2019-08-15", "GetAccountSecurityPracticeReport", "ims", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetAccountSecurityPracticeReportResponse creates a response to parse from GetAccountSecurityPracticeReport response
func CreateGetAccountSecurityPracticeReportResponse() (response *GetAccountSecurityPracticeReportResponse) {
	response = &GetAccountSecurityPracticeReportResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
