package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddDataForApiSource invokes the iot.AddDataForApiSource API synchronously
func (client *Client) AddDataForApiSource(request *AddDataForApiSourceRequest) (response *AddDataForApiSourceResponse, err error) {
	response = CreateAddDataForApiSourceResponse()
	err = client.DoAction(request, response)
	return
}

// AddDataForApiSourceWithChan invokes the iot.AddDataForApiSource API asynchronously
func (client *Client) AddDataForApiSourceWithChan(request *AddDataForApiSourceRequest) (<-chan *AddDataForApiSourceResponse, <-chan error) {
	responseChan := make(chan *AddDataForApiSourceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddDataForApiSource(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddDataForApiSourceWithCallback invokes the iot.AddDataForApiSource API asynchronously
func (client *Client) AddDataForApiSourceWithCallback(request *AddDataForApiSourceRequest, callback func(response *AddDataForApiSourceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddDataForApiSourceResponse
		var err error
		defer close(result)
		response, err = client.AddDataForApiSource(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddDataForApiSourceRequest is the request struct for api AddDataForApiSource
type AddDataForApiSourceRequest struct {
	*requests.RpcRequest
	Content       string `position:"Query" name:"Content"`
	IotInstanceId string `position:"Query" name:"IotInstanceId"`
	ApiProduct    string `position:"Body" name:"ApiProduct"`
	ApiRevision   string `position:"Body" name:"ApiRevision"`
	ApiId         string `position:"Query" name:"ApiId"`
}

// AddDataForApiSourceResponse is the response struct for api AddDataForApiSource
type AddDataForApiSourceResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Code         string `json:"Code" xml:"Code"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Data         int64  `json:"Data" xml:"Data"`
}

// CreateAddDataForApiSourceRequest creates a request to invoke AddDataForApiSource API
func CreateAddDataForApiSourceRequest() (request *AddDataForApiSourceRequest) {
	request = &AddDataForApiSourceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "AddDataForApiSource", "iot", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAddDataForApiSourceResponse creates a response to parse from AddDataForApiSource response
func CreateAddDataForApiSourceResponse() (response *AddDataForApiSourceResponse) {
	response = &AddDataForApiSourceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
