package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QuerySpeechPushJob invokes the iot.QuerySpeechPushJob API synchronously
func (client *Client) QuerySpeechPushJob(request *QuerySpeechPushJobRequest) (response *QuerySpeechPushJobResponse, err error) {
	response = CreateQuerySpeechPushJobResponse()
	err = client.DoAction(request, response)
	return
}

// QuerySpeechPushJobWithChan invokes the iot.QuerySpeechPushJob API asynchronously
func (client *Client) QuerySpeechPushJobWithChan(request *QuerySpeechPushJobRequest) (<-chan *QuerySpeechPushJobResponse, <-chan error) {
	responseChan := make(chan *QuerySpeechPushJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QuerySpeechPushJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QuerySpeechPushJobWithCallback invokes the iot.QuerySpeechPushJob API asynchronously
func (client *Client) QuerySpeechPushJobWithCallback(request *QuerySpeechPushJobRequest, callback func(response *QuerySpeechPushJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QuerySpeechPushJobResponse
		var err error
		defer close(result)
		response, err = client.QuerySpeechPushJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QuerySpeechPushJobRequest is the request struct for api QuerySpeechPushJob
type QuerySpeechPushJobRequest struct {
	*requests.RpcRequest
	StatusList    *[]string        `position:"Body" name:"StatusList"  type:"Repeated"`
	ProjectCode   string           `position:"Body" name:"ProjectCode"`
	PageId        requests.Integer `position:"Body" name:"PageId"`
	IotInstanceId string           `position:"Body" name:"IotInstanceId"`
	PageSize      requests.Integer `position:"Body" name:"PageSize"`
	PushMode      string           `position:"Body" name:"PushMode"`
	ApiProduct    string           `position:"Body" name:"ApiProduct"`
	JobCode       string           `position:"Query" name:"JobCode"`
	ApiRevision   string           `position:"Body" name:"ApiRevision"`
}

// QuerySpeechPushJobResponse is the response struct for api QuerySpeechPushJob
type QuerySpeechPushJobResponse struct {
	*responses.BaseResponse
	RequestId    string                   `json:"RequestId" xml:"RequestId"`
	Success      bool                     `json:"Success" xml:"Success"`
	Code         string                   `json:"Code" xml:"Code"`
	ErrorMessage string                   `json:"ErrorMessage" xml:"ErrorMessage"`
	Data         DataInQuerySpeechPushJob `json:"Data" xml:"Data"`
}

// CreateQuerySpeechPushJobRequest creates a request to invoke QuerySpeechPushJob API
func CreateQuerySpeechPushJobRequest() (request *QuerySpeechPushJobRequest) {
	request = &QuerySpeechPushJobRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "QuerySpeechPushJob", "iot", "openAPI")
	request.Method = requests.POST
	return
}

// CreateQuerySpeechPushJobResponse creates a response to parse from QuerySpeechPushJob response
func CreateQuerySpeechPushJobResponse() (response *QuerySpeechPushJobResponse) {
	response = &QuerySpeechPushJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
