package jarvis

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeConsoleAccessWhiteList invokes the jarvis.DescribeConsoleAccessWhiteList API synchronously
// api document: https://help.aliyun.com/api/jarvis/describeconsoleaccesswhitelist.html
func (client *Client) DescribeConsoleAccessWhiteList(request *DescribeConsoleAccessWhiteListRequest) (response *DescribeConsoleAccessWhiteListResponse, err error) {
	response = CreateDescribeConsoleAccessWhiteListResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeConsoleAccessWhiteListWithChan invokes the jarvis.DescribeConsoleAccessWhiteList API asynchronously
// api document: https://help.aliyun.com/api/jarvis/describeconsoleaccesswhitelist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeConsoleAccessWhiteListWithChan(request *DescribeConsoleAccessWhiteListRequest) (<-chan *DescribeConsoleAccessWhiteListResponse, <-chan error) {
	responseChan := make(chan *DescribeConsoleAccessWhiteListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeConsoleAccessWhiteList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeConsoleAccessWhiteListWithCallback invokes the jarvis.DescribeConsoleAccessWhiteList API asynchronously
// api document: https://help.aliyun.com/api/jarvis/describeconsoleaccesswhitelist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeConsoleAccessWhiteListWithCallback(request *DescribeConsoleAccessWhiteListRequest, callback func(response *DescribeConsoleAccessWhiteListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeConsoleAccessWhiteListResponse
		var err error
		defer close(result)
		response, err = client.DescribeConsoleAccessWhiteList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeConsoleAccessWhiteListRequest is the request struct for api DescribeConsoleAccessWhiteList
type DescribeConsoleAccessWhiteListRequest struct {
	*requests.RpcRequest
	SrcIP         string           `position:"Query" name:"SrcIP"`
	SourceIp      string           `position:"Query" name:"SourceIp"`
	PageSize      requests.Integer `position:"Query" name:"PageSize"`
	QueryProduct  string           `position:"Query" name:"queryProduct"`
	CurrentPage   requests.Integer `position:"Query" name:"CurrentPage"`
	WhiteListType requests.Integer `position:"Query" name:"WhiteListType"`
	DstIP         string           `position:"Query" name:"DstIP"`
	Lang          string           `position:"Query" name:"Lang"`
	Status        string           `position:"Query" name:"Status"`
	SourceCode    string           `position:"Query" name:"SourceCode"`
}

// DescribeConsoleAccessWhiteListResponse is the response struct for api DescribeConsoleAccessWhiteList
type DescribeConsoleAccessWhiteListResponse struct {
	*responses.BaseResponse
	RequestId string   `json:"RequestId" xml:"RequestId"`
	Module    string   `json:"module" xml:"module"`
	PageInfo  PageInfo `json:"PageInfo" xml:"PageInfo"`
	DataList  []Data   `json:"DataList" xml:"DataList"`
}

// CreateDescribeConsoleAccessWhiteListRequest creates a request to invoke DescribeConsoleAccessWhiteList API
func CreateDescribeConsoleAccessWhiteListRequest() (request *DescribeConsoleAccessWhiteListRequest) {
	request = &DescribeConsoleAccessWhiteListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("jarvis", "2018-02-06", "DescribeConsoleAccessWhiteList", "jarvis", "openAPI")
	return
}

// CreateDescribeConsoleAccessWhiteListResponse creates a response to parse from DescribeConsoleAccessWhiteList response
func CreateDescribeConsoleAccessWhiteListResponse() (response *DescribeConsoleAccessWhiteListResponse) {
	response = &DescribeConsoleAccessWhiteListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
