package linkvisual

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteEventRecordPlanDevice invokes the linkvisual.DeleteEventRecordPlanDevice API synchronously
func (client *Client) DeleteEventRecordPlanDevice(request *DeleteEventRecordPlanDeviceRequest) (response *DeleteEventRecordPlanDeviceResponse, err error) {
	response = CreateDeleteEventRecordPlanDeviceResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteEventRecordPlanDeviceWithChan invokes the linkvisual.DeleteEventRecordPlanDevice API asynchronously
func (client *Client) DeleteEventRecordPlanDeviceWithChan(request *DeleteEventRecordPlanDeviceRequest) (<-chan *DeleteEventRecordPlanDeviceResponse, <-chan error) {
	responseChan := make(chan *DeleteEventRecordPlanDeviceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteEventRecordPlanDevice(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteEventRecordPlanDeviceWithCallback invokes the linkvisual.DeleteEventRecordPlanDevice API asynchronously
func (client *Client) DeleteEventRecordPlanDeviceWithCallback(request *DeleteEventRecordPlanDeviceRequest, callback func(response *DeleteEventRecordPlanDeviceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteEventRecordPlanDeviceResponse
		var err error
		defer close(result)
		response, err = client.DeleteEventRecordPlanDevice(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteEventRecordPlanDeviceRequest is the request struct for api DeleteEventRecordPlanDevice
type DeleteEventRecordPlanDeviceRequest struct {
	*requests.RpcRequest
	IotId         string           `position:"Query" name:"IotId"`
	IotInstanceId string           `position:"Query" name:"IotInstanceId"`
	StreamType    requests.Integer `position:"Query" name:"StreamType"`
	ProductKey    string           `position:"Query" name:"ProductKey"`
	ApiProduct    string           `position:"Body" name:"ApiProduct"`
	ApiRevision   string           `position:"Body" name:"ApiRevision"`
	DeviceName    string           `position:"Query" name:"DeviceName"`
}

// DeleteEventRecordPlanDeviceResponse is the response struct for api DeleteEventRecordPlanDevice
type DeleteEventRecordPlanDeviceResponse struct {
	*responses.BaseResponse
	Code         string `json:"Code" xml:"Code"`
	RequestId    string `json:"RequestId" xml:"RequestId"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Success      bool   `json:"Success" xml:"Success"`
}

// CreateDeleteEventRecordPlanDeviceRequest creates a request to invoke DeleteEventRecordPlanDevice API
func CreateDeleteEventRecordPlanDeviceRequest() (request *DeleteEventRecordPlanDeviceRequest) {
	request = &DeleteEventRecordPlanDeviceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Linkvisual", "2018-01-20", "DeleteEventRecordPlanDevice", "Linkvisual", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteEventRecordPlanDeviceResponse creates a response to parse from DeleteEventRecordPlanDevice response
func CreateDeleteEventRecordPlanDeviceResponse() (response *DeleteEventRecordPlanDeviceResponse) {
	response = &DeleteEventRecordPlanDeviceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
