package linkvisual

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryFaceDeviceGroupsByDevice invokes the linkvisual.QueryFaceDeviceGroupsByDevice API synchronously
func (client *Client) QueryFaceDeviceGroupsByDevice(request *QueryFaceDeviceGroupsByDeviceRequest) (response *QueryFaceDeviceGroupsByDeviceResponse, err error) {
	response = CreateQueryFaceDeviceGroupsByDeviceResponse()
	err = client.DoAction(request, response)
	return
}

// QueryFaceDeviceGroupsByDeviceWithChan invokes the linkvisual.QueryFaceDeviceGroupsByDevice API asynchronously
func (client *Client) QueryFaceDeviceGroupsByDeviceWithChan(request *QueryFaceDeviceGroupsByDeviceRequest) (<-chan *QueryFaceDeviceGroupsByDeviceResponse, <-chan error) {
	responseChan := make(chan *QueryFaceDeviceGroupsByDeviceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryFaceDeviceGroupsByDevice(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryFaceDeviceGroupsByDeviceWithCallback invokes the linkvisual.QueryFaceDeviceGroupsByDevice API asynchronously
func (client *Client) QueryFaceDeviceGroupsByDeviceWithCallback(request *QueryFaceDeviceGroupsByDeviceRequest, callback func(response *QueryFaceDeviceGroupsByDeviceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryFaceDeviceGroupsByDeviceResponse
		var err error
		defer close(result)
		response, err = client.QueryFaceDeviceGroupsByDevice(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryFaceDeviceGroupsByDeviceRequest is the request struct for api QueryFaceDeviceGroupsByDevice
type QueryFaceDeviceGroupsByDeviceRequest struct {
	*requests.RpcRequest
	IsolationId   string           `position:"Query" name:"IsolationId"`
	IotInstanceId string           `position:"Query" name:"IotInstanceId"`
	PageSize      requests.Integer `position:"Query" name:"PageSize"`
	ProductKey    string           `position:"Query" name:"ProductKey"`
	PageNo        requests.Integer `position:"Query" name:"PageNo"`
	ApiProduct    string           `position:"Body" name:"ApiProduct"`
	ApiRevision   string           `position:"Body" name:"ApiRevision"`
	DeviceName    string           `position:"Query" name:"DeviceName"`
}

// QueryFaceDeviceGroupsByDeviceResponse is the response struct for api QueryFaceDeviceGroupsByDevice
type QueryFaceDeviceGroupsByDeviceResponse struct {
	*responses.BaseResponse
	Code         string `json:"Code" xml:"Code"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Data         Data   `json:"Data" xml:"Data"`
}

// CreateQueryFaceDeviceGroupsByDeviceRequest creates a request to invoke QueryFaceDeviceGroupsByDevice API
func CreateQueryFaceDeviceGroupsByDeviceRequest() (request *QueryFaceDeviceGroupsByDeviceRequest) {
	request = &QueryFaceDeviceGroupsByDeviceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Linkvisual", "2018-01-20", "QueryFaceDeviceGroupsByDevice", "Linkvisual", "openAPI")
	request.Method = requests.POST
	return
}

// CreateQueryFaceDeviceGroupsByDeviceResponse creates a response to parse from QueryFaceDeviceGroupsByDevice response
func CreateQueryFaceDeviceGroupsByDeviceResponse() (response *QueryFaceDeviceGroupsByDeviceResponse) {
	response = &QueryFaceDeviceGroupsByDeviceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
