package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// StartPlaylist invokes the live.StartPlaylist API synchronously
func (client *Client) StartPlaylist(request *StartPlaylistRequest) (response *StartPlaylistResponse, err error) {
	response = CreateStartPlaylistResponse()
	err = client.DoAction(request, response)
	return
}

// StartPlaylistWithChan invokes the live.StartPlaylist API asynchronously
func (client *Client) StartPlaylistWithChan(request *StartPlaylistRequest) (<-chan *StartPlaylistResponse, <-chan error) {
	responseChan := make(chan *StartPlaylistResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.StartPlaylist(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// StartPlaylistWithCallback invokes the live.StartPlaylist API asynchronously
func (client *Client) StartPlaylistWithCallback(request *StartPlaylistRequest, callback func(response *StartPlaylistResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *StartPlaylistResponse
		var err error
		defer close(result)
		response, err = client.StartPlaylist(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// StartPlaylistRequest is the request struct for api StartPlaylist
type StartPlaylistRequest struct {
	*requests.RpcRequest
	ResumeMode  string           `position:"Query" name:"ResumeMode"`
	StartItemId string           `position:"Query" name:"StartItemId"`
	ProgramId   string           `position:"Query" name:"ProgramId"`
	Offset      requests.Integer `position:"Query" name:"Offset"`
	OwnerId     requests.Integer `position:"Query" name:"OwnerId"`
}

// StartPlaylistResponse is the response struct for api StartPlaylist
type StartPlaylistResponse struct {
	*responses.BaseResponse
	ProgramId  string     `json:"ProgramId" xml:"ProgramId"`
	RequestId  string     `json:"RequestId" xml:"RequestId"`
	StreamInfo StreamInfo `json:"StreamInfo" xml:"StreamInfo"`
}

// CreateStartPlaylistRequest creates a request to invoke StartPlaylist API
func CreateStartPlaylistRequest() (request *StartPlaylistRequest) {
	request = &StartPlaylistRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "StartPlaylist", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateStartPlaylistResponse creates a response to parse from StartPlaylist response
func CreateStartPlaylistResponse() (response *StartPlaylistResponse) {
	response = &StartPlaylistResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
