package lto

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AuthorizeBaaS invokes the lto.AuthorizeBaaS API synchronously
func (client *Client) AuthorizeBaaS(request *AuthorizeBaaSRequest) (response *AuthorizeBaaSResponse, err error) {
	response = CreateAuthorizeBaaSResponse()
	err = client.DoAction(request, response)
	return
}

// AuthorizeBaaSWithChan invokes the lto.AuthorizeBaaS API asynchronously
func (client *Client) AuthorizeBaaSWithChan(request *AuthorizeBaaSRequest) (<-chan *AuthorizeBaaSResponse, <-chan error) {
	responseChan := make(chan *AuthorizeBaaSResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AuthorizeBaaS(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AuthorizeBaaSWithCallback invokes the lto.AuthorizeBaaS API asynchronously
func (client *Client) AuthorizeBaaSWithCallback(request *AuthorizeBaaSRequest, callback func(response *AuthorizeBaaSResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AuthorizeBaaSResponse
		var err error
		defer close(result)
		response, err = client.AuthorizeBaaS(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AuthorizeBaaSRequest is the request struct for api AuthorizeBaaS
type AuthorizeBaaSRequest struct {
	*requests.RpcRequest
}

// AuthorizeBaaSResponse is the response struct for api AuthorizeBaaS
type AuthorizeBaaSResponse struct {
	*responses.BaseResponse
	Code           string `json:"Code" xml:"Code"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string `json:"Message" xml:"Message"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
}

// CreateAuthorizeBaaSRequest creates a request to invoke AuthorizeBaaS API
func CreateAuthorizeBaaSRequest() (request *AuthorizeBaaSRequest) {
	request = &AuthorizeBaaSRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("lto", "2021-07-07", "AuthorizeBaaS", "", "")
	request.Method = requests.POST
	return
}

// CreateAuthorizeBaaSResponse creates a response to parse from AuthorizeBaaS response
func CreateAuthorizeBaaSResponse() (response *AuthorizeBaaSResponse) {
	response = &AuthorizeBaaSResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
