package lto

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteRouteRule invokes the lto.DeleteRouteRule API synchronously
func (client *Client) DeleteRouteRule(request *DeleteRouteRuleRequest) (response *DeleteRouteRuleResponse, err error) {
	response = CreateDeleteRouteRuleResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteRouteRuleWithChan invokes the lto.DeleteRouteRule API asynchronously
func (client *Client) DeleteRouteRuleWithChan(request *DeleteRouteRuleRequest) (<-chan *DeleteRouteRuleResponse, <-chan error) {
	responseChan := make(chan *DeleteRouteRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteRouteRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteRouteRuleWithCallback invokes the lto.DeleteRouteRule API asynchronously
func (client *Client) DeleteRouteRuleWithCallback(request *DeleteRouteRuleRequest, callback func(response *DeleteRouteRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteRouteRuleResponse
		var err error
		defer close(result)
		response, err = client.DeleteRouteRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteRouteRuleRequest is the request struct for api DeleteRouteRule
type DeleteRouteRuleRequest struct {
	*requests.RpcRequest
	RouteRuleId string `position:"Query" name:"RouteRuleId"`
}

// DeleteRouteRuleResponse is the response struct for api DeleteRouteRule
type DeleteRouteRuleResponse struct {
	*responses.BaseResponse
	Code           string `json:"Code" xml:"Code"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string `json:"Message" xml:"Message"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
}

// CreateDeleteRouteRuleRequest creates a request to invoke DeleteRouteRule API
func CreateDeleteRouteRuleRequest() (request *DeleteRouteRuleRequest) {
	request = &DeleteRouteRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("lto", "2021-07-07", "DeleteRouteRule", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteRouteRuleResponse creates a response to parse from DeleteRouteRule response
func CreateDeleteRouteRuleResponse() (response *DeleteRouteRuleResponse) {
	response = &DeleteRouteRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
