package mpaas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddMdsMiniConfig invokes the mpaas.AddMdsMiniConfig API synchronously
func (client *Client) AddMdsMiniConfig(request *AddMdsMiniConfigRequest) (response *AddMdsMiniConfigResponse, err error) {
	response = CreateAddMdsMiniConfigResponse()
	err = client.DoAction(request, response)
	return
}

// AddMdsMiniConfigWithChan invokes the mpaas.AddMdsMiniConfig API asynchronously
func (client *Client) AddMdsMiniConfigWithChan(request *AddMdsMiniConfigRequest) (<-chan *AddMdsMiniConfigResponse, <-chan error) {
	responseChan := make(chan *AddMdsMiniConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddMdsMiniConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddMdsMiniConfigWithCallback invokes the mpaas.AddMdsMiniConfig API asynchronously
func (client *Client) AddMdsMiniConfigWithCallback(request *AddMdsMiniConfigRequest, callback func(response *AddMdsMiniConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddMdsMiniConfigResponse
		var err error
		defer close(result)
		response, err = client.AddMdsMiniConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddMdsMiniConfigRequest is the request struct for api AddMdsMiniConfig
type AddMdsMiniConfigRequest struct {
	*requests.RpcRequest
	MpaasMappcenterMiniConfigAddJsonStr string `position:"Body" name:"MpaasMappcenterMiniConfigAddJsonStr"`
	TenantId                            string `position:"Body" name:"TenantId"`
	AppId                               string `position:"Body" name:"AppId"`
	WorkspaceId                         string `position:"Body" name:"WorkspaceId"`
}

// AddMdsMiniConfigResponse is the response struct for api AddMdsMiniConfig
type AddMdsMiniConfigResponse struct {
	*responses.BaseResponse
	ResultMessage string        `json:"ResultMessage" xml:"ResultMessage"`
	ResultCode    string        `json:"ResultCode" xml:"ResultCode"`
	RequestId     string        `json:"RequestId" xml:"RequestId"`
	ResultContent ResultContent `json:"ResultContent" xml:"ResultContent"`
}

// CreateAddMdsMiniConfigRequest creates a request to invoke AddMdsMiniConfig API
func CreateAddMdsMiniConfigRequest() (request *AddMdsMiniConfigRequest) {
	request = &AddMdsMiniConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mPaaS", "2020-10-28", "AddMdsMiniConfig", "", "")
	request.Method = requests.POST
	return
}

// CreateAddMdsMiniConfigResponse creates a response to parse from AddMdsMiniConfig response
func CreateAddMdsMiniConfigResponse() (response *AddMdsMiniConfigResponse) {
	response = &AddMdsMiniConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
