package mse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryAllSwimmingLane invokes the mse.QueryAllSwimmingLane API synchronously
func (client *Client) QueryAllSwimmingLane(request *QueryAllSwimmingLaneRequest) (response *QueryAllSwimmingLaneResponse, err error) {
	response = CreateQueryAllSwimmingLaneResponse()
	err = client.DoAction(request, response)
	return
}

// QueryAllSwimmingLaneWithChan invokes the mse.QueryAllSwimmingLane API asynchronously
func (client *Client) QueryAllSwimmingLaneWithChan(request *QueryAllSwimmingLaneRequest) (<-chan *QueryAllSwimmingLaneResponse, <-chan error) {
	responseChan := make(chan *QueryAllSwimmingLaneResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryAllSwimmingLane(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryAllSwimmingLaneWithCallback invokes the mse.QueryAllSwimmingLane API asynchronously
func (client *Client) QueryAllSwimmingLaneWithCallback(request *QueryAllSwimmingLaneRequest, callback func(response *QueryAllSwimmingLaneResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryAllSwimmingLaneResponse
		var err error
		defer close(result)
		response, err = client.QueryAllSwimmingLane(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryAllSwimmingLaneRequest is the request struct for api QueryAllSwimmingLane
type QueryAllSwimmingLaneRequest struct {
	*requests.RpcRequest
	MseSessionId   string           `position:"Query" name:"MseSessionId"`
	GroupId        requests.Integer `position:"Query" name:"GroupId"`
	Namespace      string           `position:"Query" name:"Namespace"`
	AcceptLanguage string           `position:"Query" name:"AcceptLanguage"`
}

// QueryAllSwimmingLaneResponse is the response struct for api QueryAllSwimmingLane
type QueryAllSwimmingLaneResponse struct {
	*responses.BaseResponse
	RequestId string              `json:"RequestId" xml:"RequestId"`
	Success   bool                `json:"Success" xml:"Success"`
	ErrorCode string              `json:"ErrorCode" xml:"ErrorCode"`
	Message   string              `json:"Message" xml:"Message"`
	Data      []SwimmingLaneGroup `json:"Data" xml:"Data"`
}

// CreateQueryAllSwimmingLaneRequest creates a request to invoke QueryAllSwimmingLane API
func CreateQueryAllSwimmingLaneRequest() (request *QueryAllSwimmingLaneRequest) {
	request = &QueryAllSwimmingLaneRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mse", "2019-05-31", "QueryAllSwimmingLane", "mse", "openAPI")
	request.Method = requests.POST
	return
}

// CreateQueryAllSwimmingLaneResponse creates a response to parse from QueryAllSwimmingLane response
func CreateQueryAllSwimmingLaneResponse() (response *QueryAllSwimmingLaneResponse) {
	response = &QueryAllSwimmingLaneResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
