package mseap

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// IdentifyCode invokes the mseap.IdentifyCode API synchronously
func (client *Client) IdentifyCode(request *IdentifyCodeRequest) (response *IdentifyCodeResponse, err error) {
	response = CreateIdentifyCodeResponse()
	err = client.DoAction(request, response)
	return
}

// IdentifyCodeWithChan invokes the mseap.IdentifyCode API asynchronously
func (client *Client) IdentifyCodeWithChan(request *IdentifyCodeRequest) (<-chan *IdentifyCodeResponse, <-chan error) {
	responseChan := make(chan *IdentifyCodeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.IdentifyCode(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// IdentifyCodeWithCallback invokes the mseap.IdentifyCode API asynchronously
func (client *Client) IdentifyCodeWithCallback(request *IdentifyCodeRequest, callback func(response *IdentifyCodeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *IdentifyCodeResponse
		var err error
		defer close(result)
		response, err = client.IdentifyCode(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// IdentifyCodeRequest is the request struct for api IdentifyCode
type IdentifyCodeRequest struct {
	*requests.RpcRequest
	Data                        string           `position:"Query" name:"Data"`
	UserCallerParentId          requests.Integer `position:"Query" name:"UserCallerParentId"`
	Type                        string           `position:"Query" name:"Type"`
	ApiType                     string           `position:"Query" name:"ApiType"`
	UserMfaPresent              requests.Boolean `position:"Query" name:"UserMfaPresent"`
	UserKp                      string           `position:"Query" name:"UserKp"`
	Lang                        string           `position:"Query" name:"Lang"`
	UserCallerType              string           `position:"Query" name:"UserCallerType"`
	UserSecurityToken           string           `position:"Query" name:"UserSecurityToken"`
	UserAccessKeyId             string           `position:"Query" name:"UserAccessKeyId"`
	AliyunKp                    string           `position:"Query" name:"AliyunKp"`
	UserBid                     string           `position:"Query" name:"UserBid"`
	OriginalRequest             string           `position:"Query" name:"OriginalRequest"`
	Label                       string           `position:"Query" name:"Label"`
	UserCallerSecurityTransport requests.Boolean `position:"Query" name:"UserCallerSecurityTransport"`
	UserClientIp                string           `position:"Query" name:"UserClientIp"`
	Bid                         string           `position:"Query" name:"Bid"`
}

// IdentifyCodeResponse is the response struct for api IdentifyCode
type IdentifyCodeResponse struct {
	*responses.BaseResponse
	AllowRetry     bool   `json:"AllowRetry" xml:"AllowRetry"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	ErrorMsg       string `json:"ErrorMsg" xml:"ErrorMsg"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	DynamicCode    string `json:"DynamicCode" xml:"DynamicCode"`
	ErrorCode      string `json:"ErrorCode" xml:"ErrorCode"`
	DynamicMessage string `json:"DynamicMessage" xml:"DynamicMessage"`
	Module         string `json:"Module" xml:"Module"`
	Success        bool   `json:"Success" xml:"Success"`
	AppName        string `json:"AppName" xml:"AppName"`
}

// CreateIdentifyCodeRequest creates a request to invoke IdentifyCode API
func CreateIdentifyCodeRequest() (request *IdentifyCodeRequest) {
	request = &IdentifyCodeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mseap", "2021-01-18", "IdentifyCode", "", "")
	request.Method = requests.POST
	return
}

// CreateIdentifyCodeResponse creates a response to parse from IdentifyCode response
func CreateIdentifyCodeResponse() (response *IdentifyCodeResponse) {
	response = &IdentifyCodeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
