package nas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyProtocolMountTarget invokes the nas.ModifyProtocolMountTarget API synchronously
func (client *Client) ModifyProtocolMountTarget(request *ModifyProtocolMountTargetRequest) (response *ModifyProtocolMountTargetResponse, err error) {
	response = CreateModifyProtocolMountTargetResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyProtocolMountTargetWithChan invokes the nas.ModifyProtocolMountTarget API asynchronously
func (client *Client) ModifyProtocolMountTargetWithChan(request *ModifyProtocolMountTargetRequest) (<-chan *ModifyProtocolMountTargetResponse, <-chan error) {
	responseChan := make(chan *ModifyProtocolMountTargetResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyProtocolMountTarget(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyProtocolMountTargetWithCallback invokes the nas.ModifyProtocolMountTarget API asynchronously
func (client *Client) ModifyProtocolMountTargetWithCallback(request *ModifyProtocolMountTargetRequest, callback func(response *ModifyProtocolMountTargetResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyProtocolMountTargetResponse
		var err error
		defer close(result)
		response, err = client.ModifyProtocolMountTarget(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyProtocolMountTargetRequest is the request struct for api ModifyProtocolMountTarget
type ModifyProtocolMountTargetRequest struct {
	*requests.RpcRequest
	ProtocolServiceId string           `position:"Query" name:"ProtocolServiceId"`
	ClientToken       string           `position:"Query" name:"ClientToken"`
	Description       string           `position:"Query" name:"Description"`
	FileSystemId      string           `position:"Query" name:"FileSystemId"`
	DryRun            requests.Boolean `position:"Query" name:"DryRun"`
	AccessGroupName   string           `position:"Query" name:"AccessGroupName"`
	ExportId          string           `position:"Query" name:"ExportId"`
}

// ModifyProtocolMountTargetResponse is the response struct for api ModifyProtocolMountTarget
type ModifyProtocolMountTargetResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyProtocolMountTargetRequest creates a request to invoke ModifyProtocolMountTarget API
func CreateModifyProtocolMountTargetRequest() (request *ModifyProtocolMountTargetRequest) {
	request = &ModifyProtocolMountTargetRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("NAS", "2017-06-26", "ModifyProtocolMountTarget", "nas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyProtocolMountTargetResponse creates a response to parse from ModifyProtocolMountTarget response
func CreateModifyProtocolMountTargetResponse() (response *ModifyProtocolMountTargetResponse) {
	response = &ModifyProtocolMountTargetResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
