package oceanbasepro

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeOasTopSQLList invokes the oceanbasepro.DescribeOasTopSQLList API synchronously
func (client *Client) DescribeOasTopSQLList(request *DescribeOasTopSQLListRequest) (response *DescribeOasTopSQLListResponse, err error) {
	response = CreateDescribeOasTopSQLListResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeOasTopSQLListWithChan invokes the oceanbasepro.DescribeOasTopSQLList API asynchronously
func (client *Client) DescribeOasTopSQLListWithChan(request *DescribeOasTopSQLListRequest) (<-chan *DescribeOasTopSQLListResponse, <-chan error) {
	responseChan := make(chan *DescribeOasTopSQLListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeOasTopSQLList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeOasTopSQLListWithCallback invokes the oceanbasepro.DescribeOasTopSQLList API asynchronously
func (client *Client) DescribeOasTopSQLListWithCallback(request *DescribeOasTopSQLListRequest, callback func(response *DescribeOasTopSQLListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeOasTopSQLListResponse
		var err error
		defer close(result)
		response, err = client.DescribeOasTopSQLList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeOasTopSQLListRequest is the request struct for api DescribeOasTopSQLList
type DescribeOasTopSQLListRequest struct {
	*requests.RpcRequest
	StartTime       string           `position:"Body" name:"StartTime"`
	SearchRule      string           `position:"Body" name:"SearchRule"`
	MergeDynamicSql requests.Boolean `position:"Body" name:"MergeDynamicSql"`
	DynamicSql      requests.Boolean `position:"Body" name:"DynamicSql"`
	SqlTextLength   requests.Integer `position:"Body" name:"SqlTextLength"`
	TenantId        string           `position:"Body" name:"TenantId"`
	SearchValue     string           `position:"Body" name:"SearchValue"`
	SqlId           string           `position:"Body" name:"SqlId"`
	FilterCondition string           `position:"Body" name:"FilterCondition"`
	SearchParam     string           `position:"Body" name:"SearchParam"`
	EndTime         string           `position:"Body" name:"EndTime"`
	NodeIp          string           `position:"Body" name:"NodeIp"`
	InstanceId      string           `position:"Body" name:"InstanceId"`
	DbName          string           `position:"Body" name:"DbName"`
	SearchKeyWord   string           `position:"Body" name:"SearchKeyWord"`
	AcceptLanguage  string           `position:"Body" name:"AcceptLanguage"`
}

// DescribeOasTopSQLListResponse is the response struct for api DescribeOasTopSQLList
type DescribeOasTopSQLListResponse struct {
	*responses.BaseResponse
	RequestId string                            `json:"RequestId" xml:"RequestId"`
	Data      []DataItemInDescribeOasTopSQLList `json:"Data" xml:"Data"`
}

// CreateDescribeOasTopSQLListRequest creates a request to invoke DescribeOasTopSQLList API
func CreateDescribeOasTopSQLListRequest() (request *DescribeOasTopSQLListRequest) {
	request = &DescribeOasTopSQLListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OceanBasePro", "2019-09-01", "DescribeOasTopSQLList", "oceanbase", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeOasTopSQLListResponse creates a response to parse from DescribeOasTopSQLList response
func CreateDescribeOasTopSQLListResponse() (response *DescribeOasTopSQLListResponse) {
	response = &DescribeOasTopSQLListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
