package oceanbasepro

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeOutlineBinding invokes the oceanbasepro.DescribeOutlineBinding API synchronously
func (client *Client) DescribeOutlineBinding(request *DescribeOutlineBindingRequest) (response *DescribeOutlineBindingResponse, err error) {
	response = CreateDescribeOutlineBindingResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeOutlineBindingWithChan invokes the oceanbasepro.DescribeOutlineBinding API asynchronously
func (client *Client) DescribeOutlineBindingWithChan(request *DescribeOutlineBindingRequest) (<-chan *DescribeOutlineBindingResponse, <-chan error) {
	responseChan := make(chan *DescribeOutlineBindingResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeOutlineBinding(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeOutlineBindingWithCallback invokes the oceanbasepro.DescribeOutlineBinding API asynchronously
func (client *Client) DescribeOutlineBindingWithCallback(request *DescribeOutlineBindingRequest, callback func(response *DescribeOutlineBindingResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeOutlineBindingResponse
		var err error
		defer close(result)
		response, err = client.DescribeOutlineBinding(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeOutlineBindingRequest is the request struct for api DescribeOutlineBinding
type DescribeOutlineBindingRequest struct {
	*requests.RpcRequest
	SQLId             string           `position:"Body" name:"SQLId"`
	InstanceId        string           `position:"Body" name:"InstanceId"`
	DatabaseName      string           `position:"Body" name:"DatabaseName"`
	TenantId          string           `position:"Body" name:"TenantId"`
	TableName         string           `position:"Body" name:"TableName"`
	IsConcurrentLimit requests.Boolean `position:"Body" name:"IsConcurrentLimit"`
}

// DescribeOutlineBindingResponse is the response struct for api DescribeOutlineBinding
type DescribeOutlineBindingResponse struct {
	*responses.BaseResponse
	RequestId      string         `json:"RequestId" xml:"RequestId"`
	OutlineBinding OutlineBinding `json:"OutlineBinding" xml:"OutlineBinding"`
}

// CreateDescribeOutlineBindingRequest creates a request to invoke DescribeOutlineBinding API
func CreateDescribeOutlineBindingRequest() (request *DescribeOutlineBindingRequest) {
	request = &DescribeOutlineBindingRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OceanBasePro", "2019-09-01", "DescribeOutlineBinding", "oceanbase", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeOutlineBindingResponse creates a response to parse from DescribeOutlineBinding response
func CreateDescribeOutlineBindingResponse() (response *DescribeOutlineBindingResponse) {
	response = &DescribeOutlineBindingResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
