package oceanbasepro

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeTopSQLList invokes the oceanbasepro.DescribeTopSQLList API synchronously
func (client *Client) DescribeTopSQLList(request *DescribeTopSQLListRequest) (response *DescribeTopSQLListResponse, err error) {
	response = CreateDescribeTopSQLListResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeTopSQLListWithChan invokes the oceanbasepro.DescribeTopSQLList API asynchronously
func (client *Client) DescribeTopSQLListWithChan(request *DescribeTopSQLListRequest) (<-chan *DescribeTopSQLListResponse, <-chan error) {
	responseChan := make(chan *DescribeTopSQLListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeTopSQLList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeTopSQLListWithCallback invokes the oceanbasepro.DescribeTopSQLList API asynchronously
func (client *Client) DescribeTopSQLListWithCallback(request *DescribeTopSQLListRequest, callback func(response *DescribeTopSQLListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeTopSQLListResponse
		var err error
		defer close(result)
		response, err = client.DescribeTopSQLList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeTopSQLListRequest is the request struct for api DescribeTopSQLList
type DescribeTopSQLListRequest struct {
	*requests.RpcRequest
	StartTime       string           `position:"Body" name:"StartTime"`
	PageNumber      requests.Integer `position:"Body" name:"PageNumber"`
	SearchRule      string           `position:"Body" name:"SearchRule"`
	TenantId        string           `position:"Body" name:"TenantId"`
	PageSize        requests.Integer `position:"Body" name:"PageSize"`
	SearchParameter string           `position:"Body" name:"SearchParameter"`
	SortOrder       string           `position:"Body" name:"SortOrder"`
	SearchValue     string           `position:"Body" name:"SearchValue"`
	SQLId           string           `position:"Body" name:"SQLId"`
	FilterCondition string           `position:"Body" name:"FilterCondition"`
	EndTime         string           `position:"Body" name:"EndTime"`
	NodeIp          string           `position:"Body" name:"NodeIp"`
	DbName          string           `position:"Body" name:"DbName"`
	SearchKeyWord   string           `position:"Body" name:"SearchKeyWord"`
	SortColumn      string           `position:"Body" name:"SortColumn"`
}

// DescribeTopSQLListResponse is the response struct for api DescribeTopSQLList
type DescribeTopSQLListResponse struct {
	*responses.BaseResponse
	TotalCount int64  `json:"TotalCount" xml:"TotalCount"`
	RequestId  string `json:"RequestId" xml:"RequestId"`
	TopSQLList []Data `json:"TopSQLList" xml:"TopSQLList"`
}

// CreateDescribeTopSQLListRequest creates a request to invoke DescribeTopSQLList API
func CreateDescribeTopSQLListRequest() (request *DescribeTopSQLListRequest) {
	request = &DescribeTopSQLListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OceanBasePro", "2019-09-01", "DescribeTopSQLList", "oceanbase", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeTopSQLListResponse creates a response to parse from DescribeTopSQLList response
func CreateDescribeTopSQLListResponse() (response *DescribeTopSQLListResponse) {
	response = &DescribeTopSQLListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
