package oceanbasepro

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetUploadOssUrl invokes the oceanbasepro.GetUploadOssUrl API synchronously
func (client *Client) GetUploadOssUrl(request *GetUploadOssUrlRequest) (response *GetUploadOssUrlResponse, err error) {
	response = CreateGetUploadOssUrlResponse()
	err = client.DoAction(request, response)
	return
}

// GetUploadOssUrlWithChan invokes the oceanbasepro.GetUploadOssUrl API asynchronously
func (client *Client) GetUploadOssUrlWithChan(request *GetUploadOssUrlRequest) (<-chan *GetUploadOssUrlResponse, <-chan error) {
	responseChan := make(chan *GetUploadOssUrlResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetUploadOssUrl(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetUploadOssUrlWithCallback invokes the oceanbasepro.GetUploadOssUrl API asynchronously
func (client *Client) GetUploadOssUrlWithCallback(request *GetUploadOssUrlRequest, callback func(response *GetUploadOssUrlResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetUploadOssUrlResponse
		var err error
		defer close(result)
		response, err = client.GetUploadOssUrl(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetUploadOssUrlRequest is the request struct for api GetUploadOssUrl
type GetUploadOssUrlRequest struct {
	*requests.RpcRequest
	Type                 string           `position:"Body" name:"Type"`
	EffectiveTimeMinutes requests.Integer `position:"Body" name:"EffectiveTimeMinutes"`
}

// GetUploadOssUrlResponse is the response struct for api GetUploadOssUrl
type GetUploadOssUrlResponse struct {
	*responses.BaseResponse
}

// CreateGetUploadOssUrlRequest creates a request to invoke GetUploadOssUrl API
func CreateGetUploadOssUrlRequest() (request *GetUploadOssUrlRequest) {
	request = &GetUploadOssUrlRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OceanBasePro", "2019-09-01", "GetUploadOssUrl", "oceanbase", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetUploadOssUrlResponse creates a response to parse from GetUploadOssUrl response
func CreateGetUploadOssUrlResponse() (response *GetUploadOssUrlResponse) {
	response = &GetUploadOssUrlResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
