package oos

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateSecretParameter invokes the oos.UpdateSecretParameter API synchronously
func (client *Client) UpdateSecretParameter(request *UpdateSecretParameterRequest) (response *UpdateSecretParameterResponse, err error) {
	response = CreateUpdateSecretParameterResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateSecretParameterWithChan invokes the oos.UpdateSecretParameter API asynchronously
func (client *Client) UpdateSecretParameterWithChan(request *UpdateSecretParameterRequest) (<-chan *UpdateSecretParameterResponse, <-chan error) {
	responseChan := make(chan *UpdateSecretParameterResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateSecretParameter(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateSecretParameterWithCallback invokes the oos.UpdateSecretParameter API asynchronously
func (client *Client) UpdateSecretParameterWithCallback(request *UpdateSecretParameterRequest, callback func(response *UpdateSecretParameterResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateSecretParameterResponse
		var err error
		defer close(result)
		response, err = client.UpdateSecretParameter(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateSecretParameterRequest is the request struct for api UpdateSecretParameter
type UpdateSecretParameterRequest struct {
	*requests.RpcRequest
	Description     string `position:"Query" name:"Description"`
	Tags            string `position:"Query" name:"Tags"`
	ResourceGroupId string `position:"Query" name:"ResourceGroupId"`
	Name            string `position:"Query" name:"Name"`
	Value           string `position:"Query" name:"Value"`
}

// UpdateSecretParameterResponse is the response struct for api UpdateSecretParameter
type UpdateSecretParameterResponse struct {
	*responses.BaseResponse
	RequestId string                           `json:"RequestId" xml:"RequestId"`
	Parameter ParameterInUpdateSecretParameter `json:"Parameter" xml:"Parameter"`
}

// CreateUpdateSecretParameterRequest creates a request to invoke UpdateSecretParameter API
func CreateUpdateSecretParameterRequest() (request *UpdateSecretParameterRequest) {
	request = &UpdateSecretParameterRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("oos", "2019-06-01", "UpdateSecretParameter", "oos", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateSecretParameterResponse creates a response to parse from UpdateSecretParameter response
func CreateUpdateSecretParameterResponse() (response *UpdateSecretParameterResponse) {
	response = &UpdateSecretParameterResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
