package opensearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// StartSlowQueryAnalyzer invokes the opensearch.StartSlowQueryAnalyzer API synchronously
func (client *Client) StartSlowQueryAnalyzer(request *StartSlowQueryAnalyzerRequest) (response *StartSlowQueryAnalyzerResponse, err error) {
	response = CreateStartSlowQueryAnalyzerResponse()
	err = client.DoAction(request, response)
	return
}

// StartSlowQueryAnalyzerWithChan invokes the opensearch.StartSlowQueryAnalyzer API asynchronously
func (client *Client) StartSlowQueryAnalyzerWithChan(request *StartSlowQueryAnalyzerRequest) (<-chan *StartSlowQueryAnalyzerResponse, <-chan error) {
	responseChan := make(chan *StartSlowQueryAnalyzerResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.StartSlowQueryAnalyzer(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// StartSlowQueryAnalyzerWithCallback invokes the opensearch.StartSlowQueryAnalyzer API asynchronously
func (client *Client) StartSlowQueryAnalyzerWithCallback(request *StartSlowQueryAnalyzerRequest, callback func(response *StartSlowQueryAnalyzerResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *StartSlowQueryAnalyzerResponse
		var err error
		defer close(result)
		response, err = client.StartSlowQueryAnalyzer(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// StartSlowQueryAnalyzerRequest is the request struct for api StartSlowQueryAnalyzer
type StartSlowQueryAnalyzerRequest struct {
	*requests.RoaRequest
	AppGroupIdentity string `position:"Path" name:"appGroupIdentity"`
}

// StartSlowQueryAnalyzerResponse is the response struct for api StartSlowQueryAnalyzer
type StartSlowQueryAnalyzerResponse struct {
	*responses.BaseResponse
	Result    map[string]interface{} `json:"result" xml:"result"`
	RequestId string                 `json:"requestId" xml:"requestId"`
}

// CreateStartSlowQueryAnalyzerRequest creates a request to invoke StartSlowQueryAnalyzer API
func CreateStartSlowQueryAnalyzerRequest() (request *StartSlowQueryAnalyzerRequest) {
	request = &StartSlowQueryAnalyzerRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("OpenSearch", "2017-12-25", "StartSlowQueryAnalyzer", "/v4/openapi/app-groups/[appGroupIdentity]/optimizers/slow-query/actions/run", "", "")
	request.Method = requests.POST
	return
}

// CreateStartSlowQueryAnalyzerResponse creates a response to parse from StartSlowQueryAnalyzer response
func CreateStartSlowQueryAnalyzerResponse() (response *StartSlowQueryAnalyzerResponse) {
	response = &StartSlowQueryAnalyzerResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
