package outboundbot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateNumberDistrictInfoDownloadUrl invokes the outboundbot.CreateNumberDistrictInfoDownloadUrl API synchronously
func (client *Client) CreateNumberDistrictInfoDownloadUrl(request *CreateNumberDistrictInfoDownloadUrlRequest) (response *CreateNumberDistrictInfoDownloadUrlResponse, err error) {
	response = CreateCreateNumberDistrictInfoDownloadUrlResponse()
	err = client.DoAction(request, response)
	return
}

// CreateNumberDistrictInfoDownloadUrlWithChan invokes the outboundbot.CreateNumberDistrictInfoDownloadUrl API asynchronously
func (client *Client) CreateNumberDistrictInfoDownloadUrlWithChan(request *CreateNumberDistrictInfoDownloadUrlRequest) (<-chan *CreateNumberDistrictInfoDownloadUrlResponse, <-chan error) {
	responseChan := make(chan *CreateNumberDistrictInfoDownloadUrlResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateNumberDistrictInfoDownloadUrl(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateNumberDistrictInfoDownloadUrlWithCallback invokes the outboundbot.CreateNumberDistrictInfoDownloadUrl API asynchronously
func (client *Client) CreateNumberDistrictInfoDownloadUrlWithCallback(request *CreateNumberDistrictInfoDownloadUrlRequest, callback func(response *CreateNumberDistrictInfoDownloadUrlResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateNumberDistrictInfoDownloadUrlResponse
		var err error
		defer close(result)
		response, err = client.CreateNumberDistrictInfoDownloadUrl(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateNumberDistrictInfoDownloadUrlRequest is the request struct for api CreateNumberDistrictInfoDownloadUrl
type CreateNumberDistrictInfoDownloadUrlRequest struct {
	*requests.RpcRequest
	VersionId string `position:"Query" name:"VersionId"`
}

// CreateNumberDistrictInfoDownloadUrlResponse is the response struct for api CreateNumberDistrictInfoDownloadUrl
type CreateNumberDistrictInfoDownloadUrlResponse struct {
	*responses.BaseResponse
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	FileHttpUrl    string `json:"FileHttpUrl" xml:"FileHttpUrl"`
}

// CreateCreateNumberDistrictInfoDownloadUrlRequest creates a request to invoke CreateNumberDistrictInfoDownloadUrl API
func CreateCreateNumberDistrictInfoDownloadUrlRequest() (request *CreateNumberDistrictInfoDownloadUrlRequest) {
	request = &CreateNumberDistrictInfoDownloadUrlRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OutboundBot", "2019-12-26", "CreateNumberDistrictInfoDownloadUrl", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateNumberDistrictInfoDownloadUrlResponse creates a response to parse from CreateNumberDistrictInfoDownloadUrl response
func CreateCreateNumberDistrictInfoDownloadUrlResponse() (response *CreateNumberDistrictInfoDownloadUrlResponse) {
	response = &CreateNumberDistrictInfoDownloadUrlResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
