package outboundbot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetAsrServerInfo invokes the outboundbot.GetAsrServerInfo API synchronously
func (client *Client) GetAsrServerInfo(request *GetAsrServerInfoRequest) (response *GetAsrServerInfoResponse, err error) {
	response = CreateGetAsrServerInfoResponse()
	err = client.DoAction(request, response)
	return
}

// GetAsrServerInfoWithChan invokes the outboundbot.GetAsrServerInfo API asynchronously
func (client *Client) GetAsrServerInfoWithChan(request *GetAsrServerInfoRequest) (<-chan *GetAsrServerInfoResponse, <-chan error) {
	responseChan := make(chan *GetAsrServerInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetAsrServerInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetAsrServerInfoWithCallback invokes the outboundbot.GetAsrServerInfo API asynchronously
func (client *Client) GetAsrServerInfoWithCallback(request *GetAsrServerInfoRequest, callback func(response *GetAsrServerInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetAsrServerInfoResponse
		var err error
		defer close(result)
		response, err = client.GetAsrServerInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetAsrServerInfoRequest is the request struct for api GetAsrServerInfo
type GetAsrServerInfoRequest struct {
	*requests.RpcRequest
	StrategyLevel requests.Integer `position:"Query" name:"StrategyLevel"`
	EntryId       string           `position:"Query" name:"EntryId"`
}

// GetAsrServerInfoResponse is the response struct for api GetAsrServerInfo
type GetAsrServerInfoResponse struct {
	*responses.BaseResponse
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
}

// CreateGetAsrServerInfoRequest creates a request to invoke GetAsrServerInfo API
func CreateGetAsrServerInfoRequest() (request *GetAsrServerInfoRequest) {
	request = &GetAsrServerInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OutboundBot", "2019-12-26", "GetAsrServerInfo", "", "")
	request.Method = requests.POST
	return
}

// CreateGetAsrServerInfoResponse creates a response to parse from GetAsrServerInfo response
func CreateGetAsrServerInfoResponse() (response *GetAsrServerInfoResponse) {
	response = &GetAsrServerInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
