package paifeaturestore

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListProjectFeatureViews invokes the paifeaturestore.ListProjectFeatureViews API synchronously
func (client *Client) ListProjectFeatureViews(request *ListProjectFeatureViewsRequest) (response *ListProjectFeatureViewsResponse, err error) {
	response = CreateListProjectFeatureViewsResponse()
	err = client.DoAction(request, response)
	return
}

// ListProjectFeatureViewsWithChan invokes the paifeaturestore.ListProjectFeatureViews API asynchronously
func (client *Client) ListProjectFeatureViewsWithChan(request *ListProjectFeatureViewsRequest) (<-chan *ListProjectFeatureViewsResponse, <-chan error) {
	responseChan := make(chan *ListProjectFeatureViewsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListProjectFeatureViews(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListProjectFeatureViewsWithCallback invokes the paifeaturestore.ListProjectFeatureViews API asynchronously
func (client *Client) ListProjectFeatureViewsWithCallback(request *ListProjectFeatureViewsRequest, callback func(response *ListProjectFeatureViewsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListProjectFeatureViewsResponse
		var err error
		defer close(result)
		response, err = client.ListProjectFeatureViews(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListProjectFeatureViewsRequest is the request struct for api ListProjectFeatureViews
type ListProjectFeatureViewsRequest struct {
	*requests.RoaRequest
	InstanceId string `position:"Path" name:"InstanceId"`
	ProjectId  string `position:"Path" name:"ProjectId"`
}

// ListProjectFeatureViewsResponse is the response struct for api ListProjectFeatureViews
type ListProjectFeatureViewsResponse struct {
	*responses.BaseResponse
	RequestId    string             `json:"RequestId" xml:"RequestId"`
	TotalCount   int64              `json:"TotalCount" xml:"TotalCount"`
	FeatureViews []FeatureViewsItem `json:"FeatureViews" xml:"FeatureViews"`
}

// CreateListProjectFeatureViewsRequest creates a request to invoke ListProjectFeatureViews API
func CreateListProjectFeatureViewsRequest() (request *ListProjectFeatureViewsRequest) {
	request = &ListProjectFeatureViewsRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("PaiFeatureStore", "2023-06-21", "ListProjectFeatureViews", "/api/v1/instances/[InstanceId]/projects/[ProjectId]/featureviews", "", "")
	request.Method = requests.GET
	return
}

// CreateListProjectFeatureViewsResponse creates a response to parse from ListProjectFeatureViews response
func CreateListProjectFeatureViewsResponse() (response *ListProjectFeatureViewsResponse) {
	response = &ListProjectFeatureViewsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
