package pairecservice

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateInstanceResource invokes the pairecservice.CreateInstanceResource API synchronously
func (client *Client) CreateInstanceResource(request *CreateInstanceResourceRequest) (response *CreateInstanceResourceResponse, err error) {
	response = CreateCreateInstanceResourceResponse()
	err = client.DoAction(request, response)
	return
}

// CreateInstanceResourceWithChan invokes the pairecservice.CreateInstanceResource API asynchronously
func (client *Client) CreateInstanceResourceWithChan(request *CreateInstanceResourceRequest) (<-chan *CreateInstanceResourceResponse, <-chan error) {
	responseChan := make(chan *CreateInstanceResourceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateInstanceResource(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateInstanceResourceWithCallback invokes the pairecservice.CreateInstanceResource API asynchronously
func (client *Client) CreateInstanceResourceWithCallback(request *CreateInstanceResourceRequest, callback func(response *CreateInstanceResourceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateInstanceResourceResponse
		var err error
		defer close(result)
		response, err = client.CreateInstanceResource(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateInstanceResourceRequest is the request struct for api CreateInstanceResource
type CreateInstanceResourceRequest struct {
	*requests.RoaRequest
	InstanceId string `position:"Path" name:"InstanceId"`
	Body       string `position:"Body" name:"body"`
}

// CreateInstanceResourceResponse is the response struct for api CreateInstanceResource
type CreateInstanceResourceResponse struct {
	*responses.BaseResponse
	RequestId  string `json:"RequestId" xml:"RequestId"`
	ResourceId string `json:"ResourceId" xml:"ResourceId"`
}

// CreateCreateInstanceResourceRequest creates a request to invoke CreateInstanceResource API
func CreateCreateInstanceResourceRequest() (request *CreateInstanceResourceRequest) {
	request = &CreateInstanceResourceRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("PaiRecService", "2022-12-13", "CreateInstanceResource", "/api/v1/instances/[InstanceId]/resources", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateInstanceResourceResponse creates a response to parse from CreateInstanceResource response
func CreateCreateInstanceResourceResponse() (response *CreateInstanceResourceResponse) {
	response = &CreateInstanceResourceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
