package pairecservice

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListFeatureConsistencyCheckJobs invokes the pairecservice.ListFeatureConsistencyCheckJobs API synchronously
func (client *Client) ListFeatureConsistencyCheckJobs(request *ListFeatureConsistencyCheckJobsRequest) (response *ListFeatureConsistencyCheckJobsResponse, err error) {
	response = CreateListFeatureConsistencyCheckJobsResponse()
	err = client.DoAction(request, response)
	return
}

// ListFeatureConsistencyCheckJobsWithChan invokes the pairecservice.ListFeatureConsistencyCheckJobs API asynchronously
func (client *Client) ListFeatureConsistencyCheckJobsWithChan(request *ListFeatureConsistencyCheckJobsRequest) (<-chan *ListFeatureConsistencyCheckJobsResponse, <-chan error) {
	responseChan := make(chan *ListFeatureConsistencyCheckJobsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListFeatureConsistencyCheckJobs(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListFeatureConsistencyCheckJobsWithCallback invokes the pairecservice.ListFeatureConsistencyCheckJobs API asynchronously
func (client *Client) ListFeatureConsistencyCheckJobsWithCallback(request *ListFeatureConsistencyCheckJobsRequest, callback func(response *ListFeatureConsistencyCheckJobsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListFeatureConsistencyCheckJobsResponse
		var err error
		defer close(result)
		response, err = client.ListFeatureConsistencyCheckJobs(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListFeatureConsistencyCheckJobsRequest is the request struct for api ListFeatureConsistencyCheckJobs
type ListFeatureConsistencyCheckJobsRequest struct {
	*requests.RoaRequest
	PageNumber string `position:"Query" name:"PageNumber"`
	InstanceId string `position:"Query" name:"InstanceId"`
	PageSize   string `position:"Query" name:"PageSize"`
	SortBy     string `position:"Query" name:"SortBy"`
	Order      string `position:"Query" name:"Order"`
	Status     string `position:"Query" name:"Status"`
}

// ListFeatureConsistencyCheckJobsResponse is the response struct for api ListFeatureConsistencyCheckJobs
type ListFeatureConsistencyCheckJobsResponse struct {
	*responses.BaseResponse
	RequestId                   string                            `json:"RequestId" xml:"RequestId"`
	TotalCount                  string                            `json:"TotalCount" xml:"TotalCount"`
	FeatureConsistencyCheckJobs []FeatureConsistencyCheckJobsItem `json:"FeatureConsistencyCheckJobs" xml:"FeatureConsistencyCheckJobs"`
}

// CreateListFeatureConsistencyCheckJobsRequest creates a request to invoke ListFeatureConsistencyCheckJobs API
func CreateListFeatureConsistencyCheckJobsRequest() (request *ListFeatureConsistencyCheckJobsRequest) {
	request = &ListFeatureConsistencyCheckJobsRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("PaiRecService", "2022-12-13", "ListFeatureConsistencyCheckJobs", "/api/v1/featureconsistencycheck/jobs", "", "")
	request.Method = requests.GET
	return
}

// CreateListFeatureConsistencyCheckJobsResponse creates a response to parse from ListFeatureConsistencyCheckJobs response
func CreateListFeatureConsistencyCheckJobsResponse() (response *ListFeatureConsistencyCheckJobsResponse) {
	response = &ListFeatureConsistencyCheckJobsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
