package pairecservice

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// PushAllExperiment invokes the pairecservice.PushAllExperiment API synchronously
func (client *Client) PushAllExperiment(request *PushAllExperimentRequest) (response *PushAllExperimentResponse, err error) {
	response = CreatePushAllExperimentResponse()
	err = client.DoAction(request, response)
	return
}

// PushAllExperimentWithChan invokes the pairecservice.PushAllExperiment API asynchronously
func (client *Client) PushAllExperimentWithChan(request *PushAllExperimentRequest) (<-chan *PushAllExperimentResponse, <-chan error) {
	responseChan := make(chan *PushAllExperimentResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.PushAllExperiment(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// PushAllExperimentWithCallback invokes the pairecservice.PushAllExperiment API asynchronously
func (client *Client) PushAllExperimentWithCallback(request *PushAllExperimentRequest, callback func(response *PushAllExperimentResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *PushAllExperimentResponse
		var err error
		defer close(result)
		response, err = client.PushAllExperiment(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// PushAllExperimentRequest is the request struct for api PushAllExperiment
type PushAllExperimentRequest struct {
	*requests.RoaRequest
	Body         string `position:"Body" name:"body"`
	ExperimentId string `position:"Path" name:"ExperimentId"`
}

// PushAllExperimentResponse is the response struct for api PushAllExperiment
type PushAllExperimentResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreatePushAllExperimentRequest creates a request to invoke PushAllExperiment API
func CreatePushAllExperimentRequest() (request *PushAllExperimentRequest) {
	request = &PushAllExperimentRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("PaiRecService", "2022-12-13", "PushAllExperiment", "/api/v1/experiments/[ExperimentId]/action/pushall", "", "")
	request.Method = requests.POST
	return
}

// CreatePushAllExperimentResponse creates a response to parse from PushAllExperiment response
func CreatePushAllExperimentResponse() (response *PushAllExperimentResponse) {
	response = &PushAllExperimentResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
