package pairecservice

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateTableMeta invokes the pairecservice.UpdateTableMeta API synchronously
func (client *Client) UpdateTableMeta(request *UpdateTableMetaRequest) (response *UpdateTableMetaResponse, err error) {
	response = CreateUpdateTableMetaResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateTableMetaWithChan invokes the pairecservice.UpdateTableMeta API asynchronously
func (client *Client) UpdateTableMetaWithChan(request *UpdateTableMetaRequest) (<-chan *UpdateTableMetaResponse, <-chan error) {
	responseChan := make(chan *UpdateTableMetaResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateTableMeta(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateTableMetaWithCallback invokes the pairecservice.UpdateTableMeta API asynchronously
func (client *Client) UpdateTableMetaWithCallback(request *UpdateTableMetaRequest, callback func(response *UpdateTableMetaResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateTableMetaResponse
		var err error
		defer close(result)
		response, err = client.UpdateTableMeta(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateTableMetaRequest is the request struct for api UpdateTableMeta
type UpdateTableMetaRequest struct {
	*requests.RoaRequest
	Body        string `position:"Body" name:"body"`
	TableMetaId string `position:"Path" name:"TableMetaId"`
}

// UpdateTableMetaResponse is the response struct for api UpdateTableMeta
type UpdateTableMetaResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateTableMetaRequest creates a request to invoke UpdateTableMeta API
func CreateUpdateTableMetaRequest() (request *UpdateTableMetaRequest) {
	request = &UpdateTableMetaRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("PaiRecService", "2022-12-13", "UpdateTableMeta", "/api/v1/tablemetas/[TableMetaId]", "", "")
	request.Method = requests.PUT
	return
}

// CreateUpdateTableMetaResponse creates a response to parse from UpdateTableMeta response
func CreateUpdateTableMetaResponse() (response *UpdateTableMetaResponse) {
	response = &UpdateTableMetaResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
