package polardb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeLicenseOrderDetails invokes the polardb.DescribeLicenseOrderDetails API synchronously
func (client *Client) DescribeLicenseOrderDetails(request *DescribeLicenseOrderDetailsRequest) (response *DescribeLicenseOrderDetailsResponse, err error) {
	response = CreateDescribeLicenseOrderDetailsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeLicenseOrderDetailsWithChan invokes the polardb.DescribeLicenseOrderDetails API asynchronously
func (client *Client) DescribeLicenseOrderDetailsWithChan(request *DescribeLicenseOrderDetailsRequest) (<-chan *DescribeLicenseOrderDetailsResponse, <-chan error) {
	responseChan := make(chan *DescribeLicenseOrderDetailsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeLicenseOrderDetails(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeLicenseOrderDetailsWithCallback invokes the polardb.DescribeLicenseOrderDetails API asynchronously
func (client *Client) DescribeLicenseOrderDetailsWithCallback(request *DescribeLicenseOrderDetailsRequest, callback func(response *DescribeLicenseOrderDetailsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeLicenseOrderDetailsResponse
		var err error
		defer close(result)
		response, err = client.DescribeLicenseOrderDetails(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeLicenseOrderDetailsRequest is the request struct for api DescribeLicenseOrderDetails
type DescribeLicenseOrderDetailsRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	AliyunOrderId        string           `position:"Query" name:"AliyunOrderId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeLicenseOrderDetailsResponse is the response struct for api DescribeLicenseOrderDetails
type DescribeLicenseOrderDetailsResponse struct {
	*responses.BaseResponse
	ActivatedCodeCount         int    `json:"ActivatedCodeCount" xml:"ActivatedCodeCount"`
	ActivationCodeQuota        int    `json:"ActivationCodeQuota" xml:"ActivationCodeQuota"`
	AliyunOrderId              string `json:"AliyunOrderId" xml:"AliyunOrderId"`
	AllowEmptySystemIdentifier bool   `json:"AllowEmptySystemIdentifier" xml:"AllowEmptySystemIdentifier"`
	Engine                     string `json:"Engine" xml:"Engine"`
	GmtCreated                 string `json:"GmtCreated" xml:"GmtCreated"`
	GmtModified                string `json:"GmtModified" xml:"GmtModified"`
	IsVirtualOrder             bool   `json:"IsVirtualOrder" xml:"IsVirtualOrder"`
	IsVirtualOrderFrozen       bool   `json:"IsVirtualOrderFrozen" xml:"IsVirtualOrderFrozen"`
	PackageType                string `json:"PackageType" xml:"PackageType"`
	PackageValidity            string `json:"PackageValidity" xml:"PackageValidity"`
	PurchaseChannel            string `json:"PurchaseChannel" xml:"PurchaseChannel"`
	RequestId                  string `json:"RequestId" xml:"RequestId"`
	VirtualOrderId             string `json:"VirtualOrderId" xml:"VirtualOrderId"`
}

// CreateDescribeLicenseOrderDetailsRequest creates a request to invoke DescribeLicenseOrderDetails API
func CreateDescribeLicenseOrderDetailsRequest() (request *DescribeLicenseOrderDetailsRequest) {
	request = &DescribeLicenseOrderDetailsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("polardb", "2017-08-01", "DescribeLicenseOrderDetails", "polardb", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeLicenseOrderDetailsResponse creates a response to parse from DescribeLicenseOrderDetails response
func CreateDescribeLicenseOrderDetailsResponse() (response *DescribeLicenseOrderDetailsResponse) {
	response = &DescribeLicenseOrderDetailsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
