package polardb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// EvaluateRegionResource invokes the polardb.EvaluateRegionResource API synchronously
func (client *Client) EvaluateRegionResource(request *EvaluateRegionResourceRequest) (response *EvaluateRegionResourceResponse, err error) {
	response = CreateEvaluateRegionResourceResponse()
	err = client.DoAction(request, response)
	return
}

// EvaluateRegionResourceWithChan invokes the polardb.EvaluateRegionResource API asynchronously
func (client *Client) EvaluateRegionResourceWithChan(request *EvaluateRegionResourceRequest) (<-chan *EvaluateRegionResourceResponse, <-chan error) {
	responseChan := make(chan *EvaluateRegionResourceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.EvaluateRegionResource(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// EvaluateRegionResourceWithCallback invokes the polardb.EvaluateRegionResource API asynchronously
func (client *Client) EvaluateRegionResourceWithCallback(request *EvaluateRegionResourceRequest, callback func(response *EvaluateRegionResourceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *EvaluateRegionResourceResponse
		var err error
		defer close(result)
		response, err = client.EvaluateRegionResource(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// EvaluateRegionResourceRequest is the request struct for api EvaluateRegionResource
type EvaluateRegionResourceRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	DBInstanceConnType   string           `position:"Query" name:"DBInstanceConnType"`
	ResourceGroupId      string           `position:"Query" name:"ResourceGroupId"`
	DBNodeClass          string           `position:"Query" name:"DBNodeClass"`
	DispenseMode         string           `position:"Query" name:"DispenseMode"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	NeedMaxScaleLink     string           `position:"Query" name:"NeedMaxScaleLink"`
	DBType               string           `position:"Query" name:"DBType"`
	DBVersion            string           `position:"Query" name:"DBVersion"`
	SubDomain            string           `position:"Query" name:"SubDomain"`
	ZoneId               string           `position:"Query" name:"ZoneId"`
}

// EvaluateRegionResourceResponse is the response struct for api EvaluateRegionResource
type EvaluateRegionResourceResponse struct {
	*responses.BaseResponse
	RequestId           string `json:"RequestId" xml:"RequestId"`
	DBInstanceAvailable string `json:"DBInstanceAvailable" xml:"DBInstanceAvailable"`
	DBType              string `json:"DBType" xml:"DBType"`
	DBVersion           string `json:"DBVersion" xml:"DBVersion"`
}

// CreateEvaluateRegionResourceRequest creates a request to invoke EvaluateRegionResource API
func CreateEvaluateRegionResourceRequest() (request *EvaluateRegionResourceRequest) {
	request = &EvaluateRegionResourceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("polardb", "2017-08-01", "EvaluateRegionResource", "polardb", "openAPI")
	request.Method = requests.POST
	return
}

// CreateEvaluateRegionResourceResponse creates a response to parse from EvaluateRegionResource response
func CreateEvaluateRegionResourceResponse() (response *EvaluateRegionResourceResponse) {
	response = &EvaluateRegionResourceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
